/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.RouterKey;
import com.digiwin.athena.cdme.core.config.CdmeEaiProp;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.ActiveDetectionRuleDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.provider.IOpenApiService;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.IActiveMonitorFacadeService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleService;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="cdmeOpenApiService")
public class OpenApiService
implements IOpenApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiService.class);
    @Autowired
    private IActiveMonitorFacadeService activeMonitorFacadeService;
    @Autowired
    private CdmeEaiProp eaiProp;
    @Autowired
    private IMonitorRuleService ruleService;

    @Override
    @RouterKey
    public String postCallExecution(Map<String, String> headers, String bodyStr) {
        JSONArray changeObjects;
        JSONObject serviceObj = JsonUtil.getObject(headers.get("digi-service"));
        if (CollectionUtil.isEmpty((Map)serviceObj)) {
            return ResultHelper.generateEAIFailResult(ErrorCodeEnum.DIGI_SERVICE_EMPTY);
        }
        if (!this.eaiProp.getEaiHostProd().equals(serviceObj.getString("prod")) || !"MonitorEngine".equals(serviceObj.getString("id"))) {
            return ResultHelper.generateEAIFailResult(ErrorCodeEnum.DIGI_SERVICE_WRONG);
        }
        String tenantId = serviceObj.getString("tenant_id");
        if (StringUtil.isBlank(tenantId)) {
            return ResultHelper.generateEAIFailResult(ErrorCodeEnum.DIGI_SERVICE_TENANT_ID_EMPTY);
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        DWServiceContext.getContext().getRequestHeader().put("routerKey", request.getHeader("routerKey"));
        JSONObject messageBody = JsonUtil.getObject(bodyStr);
        EocDto eocDto = JsonUtil.getObject(headers.get("digi-eocmap"), EocDto.class);
        if (eocDto == null) {
            eocDto = new EocDto();
        }
        LOGGER.info("doInitiativeExecute \u5165\u53c2\uff1atenantId:{}, eocMap:{}, messageBody:{}", new Object[]{tenantId, eocDto, messageBody});
        String ruleId = this.getRuleId(messageBody);
        if (StringUtil.isBlank(ruleId)) {
            LOGGER.error("\u4fa6\u6d4b\u89c4\u5219\u4f20\u503c\u4e3a\u7a7a, \u8bf7\u67e5\u770b!");
            return ResultHelper.generateEAIFailResult(ErrorCodeEnum.REPORT_PARAM_ERR);
        }
        Optional<MonitorRuleModel> ruleOptional = this.getMonitorRule(ruleId, tenantId, eocDto);
        if (!ruleOptional.isPresent()) {
            LOGGER.error("ruleId\uff1a{}\uff0ctenantId\uff1a{}\u4fa6\u6d4b\u89c4\u5219\u672a\u540c\u6b65, \u8bf7\u67e5\u770b!", (Object)ruleId, (Object)tenantId);
            return ResultHelper.generateEAIFailResult(ErrorCodeEnum.RULE_UN_SYNCHRONIZED);
        }
        MonitorRuleModel ruleModel = ruleOptional.get();
        ActiveDetectionRuleDto detectionRuleDto = new ActiveDetectionRuleDto(eocDto, ruleModel, changeObjects = this.getChangeObjects(messageBody));
        ResultDto rs = this.activeMonitorFacadeService.execute(detectionRuleDto);
        if (MonitorHelper.isResultFail(rs)) {
            LOGGER.error("ruleId\uff1a{}\uff0ctenantId\uff1a{}\u4fa6\u6d4b\u89c4\u5219\u5931\u8d25:[{}], \u8bf7\u67e5\u770b!", new Object[]{ruleId, tenantId, rs});
            return ResultHelper.generateEAIResult("-1", rs.getMessage());
        }
        return ResultHelper.generateEAIResult("0", rs.toString());
    }

    private String getRuleId(JSONObject messageBody) {
        return this.getRequestObjects(messageBody).getJSONObject(0).getString("rule_id");
    }

    private JSONArray getChangeObjects(JSONObject messageBody) {
        return this.getRequestObjects(messageBody).getJSONObject(0).getJSONArray("change_objects");
    }

    private JSONArray getRequestObjects(JSONObject messageBody) {
        return messageBody.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("request_objects");
    }

    private Optional<MonitorRuleModel> getMonitorRule(String ruleId, String tenantId, EocDto eocDto) {
        MonitorRuleModel ruleModel = this.ruleService.getByRuleIdAndTenantIdAndEoc(ruleId, tenantId, eocDto);
        if (ruleModel == null && MonitorHelper.calculateWeight(eocDto) != 0) {
            ruleModel = this.ruleService.getByRuleIdAndTenantIdAndEoc(ruleId, tenantId, new EocDto());
        }
        return Optional.ofNullable(ruleModel);
    }
}

