/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.auth.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service(value="cdmeContextFacadeService")
public class ContextFacadeService
implements IContextFacadeService {
    private final IThemeMapClient themeMapClient;
    private final IIamClient iamClient;

    public ContextFacadeService(IThemeMapClient themeMapClient, IIamClient iamClient) {
        this.themeMapClient = themeMapClient;
        this.iamClient = iamClient;
    }

    @Override
    public void constructContext(String tenantId) throws Exception {
        this.addRouterKeyToContext(tenantId);
        this.addTenantSidAndTokenToContext(tenantId);
    }

    @Override
    public void constructIntegrationContext(String tenantId) throws Exception {
        this.addRouterKeyToContext(tenantId);
        this.addIntegrationToContext(tenantId);
    }

    private void addIntegrationToContext(String tenantId) {
        JSONObject integration = this.iamClient.getIntegration(tenantId);
        DWServiceContext.getContext().setToken(integration.getString("token"));
    }

    private void addRouterKeyToContext(String tenantId) {
        DWServiceContext.getContext().getRequestHeader().put("routerKey", tenantId);
    }

    private void addTenantSidAndTokenToContext(String tenantId) throws Exception {
        JSONObject iamResult = this.getIamResult(tenantId);
        HashMap<String, Long> profile = new HashMap<String, Long>(1);
        profile.put("tenantSid", iamResult.getLong("tenantSid"));
        DWServiceContext.getContext().setProfile(profile);
        DWServiceContext.getContext().setToken(iamResult.getString("token"));
    }

    private JSONObject getIamResult(String tenantId) throws Exception {
        String secretKey = this.themeMapClient.getTenantSecretKey(tenantId);
        JSONObject iamResult = this.iamClient.getLoginResponse(secretKey);
        if (iamResult.isEmpty()) {
            throw new BusinessException(ErrorCodeEnum.IAM_GET_TOKEN_EMPTY);
        }
        return iamResult;
    }
}

