package com.digiwin.athena.cdme.pojo.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.CollectionUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangzhi@digiwin.com
 * @date 2021/7/6
 */
public class ProcessPageDto {
    @JSONField(serialize = false)
    private List<JSONArray> successChangeObjects;

    private List<ResultDto> errorResponse;
    /** 失败/成功的返回信息 */
    private List<JSON> response;
    /** 总页数 */
    private int pageNum;
    /** 每页的数据量 */
    private int pageSize;

    public ProcessPageDto(int pageNum, int pageSize) {
        this.successChangeObjects = new ArrayList<>();
        this.errorResponse = new ArrayList<>();
        this.response = new ArrayList<>();
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public void addSuccessChangeObjects(JSONArray objects) {
        if (null == objects) {
            this.successChangeObjects.add(new JSONArray());
            return;
        }
        this.successChangeObjects.add(objects);
    }

    public void addErrorResponse(ResultDto failRs) {
        this.response.add(JsonUtil.getJson(failRs));
        this.errorResponse.add(failRs);
    }

    public void addSuccessResponse(JSON json) {
        this.response.add(json);
    }

    public boolean allSuccess() {
        return CollectionUtil.isEmpty(errorResponse);
    }

    public boolean partFail() {
        return errorResponse.size() > 0 && errorResponse.size() != pageNum;
    }

    public boolean allFail() {
        return errorResponse.size() == pageNum;
    }

    /** 需要异步缓存的侦测数据 */
    public JSONArray genSuccessChangeObjects(){
        if(errorResponse.size() == pageNum){
            return new JSONArray();
        }
        return new JSONArray(successChangeObjects.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public List<JSONArray> getSuccessChangeObjects() {
        return successChangeObjects;
    }

    public List<ResultDto> getErrorResponse() {
        return errorResponse;
    }

    public List<JSON> getResponse() {
        return response;
    }

    public int getPageNum() {
        return pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
