package com.digiwin.athena.cdme.service.facade.detection.execution.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.enums.SuccessMessageEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.ExecuteRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ProcessPageDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.facade.detection.data.IPreDetectionService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IExectionService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IFinishExecutionService;
import com.digiwin.athena.cdme.service.facade.detection.execution.IProcessExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/4 15:58
 */
@Service("cdmeExecutionService")
public class ExecutionService implements IExectionService {

    private static Logger LOGGER = LoggerFactory.getLogger(ExecutionService.class);

    private final IPreDetectionService preDetectionService;

    private final IProcessExecutionService processExecutionService;

    private final IFinishExecutionService finishExecutionService;

    public ExecutionService(IPreDetectionService preDetectionService, IProcessExecutionService processExecutionService, IFinishExecutionService finishExecutionService) {
        this.preDetectionService = preDetectionService;
        this.processExecutionService = processExecutionService;
        this.finishExecutionService = finishExecutionService;
    }

    @Override
    public ResultDto<ProcessPageDto> execute(ExecuteRequestDto requestDto) {
        MonitorRuleModel ruleModel = requestDto.getRuleModel();
        if (CollectionUtil.isEmpty(requestDto.getData()) && !MonitorHelper.isGoOn(ruleModel.getCategory(), ruleModel.getMonitorRule())) {
            if (CollectionUtil.isEmpty(requestDto.getDupData())) {
                LOGGER.info("侦测到的数据为空且数据为空时不再继续发起流程,侦测处理结束！");
                return ResultHelper.generateLocaleResult(true, SuccessMessageEnum.MONITOR_DATA_EMPTY.getCode());
            } else {
                LOGGER.info("去重后数据为空,无需调用执行,侦测处理结束！");
                return ResultHelper.generateLocaleResult(true, SuccessMessageEnum.DUP_DATA_EMPTY.getCode());
            }
        }
        ResultDto<Map<String, JSONObject>> preResult = preDetectionService.parseConfig(requestDto.getRuleModel(), requestDto.getTimeRange());
        if (MonitorHelper.isResultFail(preResult)) {
            return ResultHelper.generateFailResult(preResult.getCode(), preResult.getMessage());
        }
        ProcessPageDto executeRs = processExecutionService.processExecutionByPage(requestDto, preResult.getData());
        if (executeRs.allFail()) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.DETECTION_ALL_FAILE, executeRs);
        }
        ResultDto finishRs = finishExecutionService.syncProcess(requestDto, executeRs);
        if (MonitorHelper.isResultFail(finishRs)) {
            return ResultHelper.generateFailResult(finishRs.getCode(), finishRs.getMessage(), executeRs);
        }
        if (executeRs.partFail()) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.DETECTION_PART_FAILE, executeRs);
        }
        return ResultHelper.generateLocaleResult(true, SuccessMessageEnum.ALL_PAGE_SUCCESS.getCode(), executeRs);
    }
}
