package com.digiwin.athena.cdme.service.srp.db.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.repository.dao.CdmeMqttServerConfigMapper;
import com.digiwin.athena.cdme.repository.model.MqttServerConfigModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMqttServerConfigService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/***
 * @author Alor
 */
@Service("cdmeMqttServerConfigService")
public class MqttServerConfigService extends AbstractRepositorService<CdmeMqttServerConfigMapper, MqttServerConfigModel> implements IMqttServerConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttServerConfigService.class);

    public MqttServerConfigService(CdmeMqttServerConfigMapper mapper) {
        super(mapper);
    }

    @Override
    public List<MqttServerConfigModel> getServerList() {
        LOGGER.info("开始查询mqtt服务配置信息");
        List<MqttServerConfigModel> mqttServerConfigModels = mapper.selectList(Wrappers.<MqttServerConfigModel>lambdaQuery().eq(MqttServerConfigModel::getIsDeleted, 0));
        LOGGER.info("查询mqtt服务配置信息结果：{}", mqttServerConfigModels);
        if (CollectionUtils.isNotEmpty(mqttServerConfigModels)) {
            return mqttServerConfigModels;
        } else {
            return Lists.newArrayList();
        }
    }

    @Override
    public MqttServerConfigModel getServerListByBusinessSources(String businessSources) {
        LOGGER.info("开始查询mqtt服务配置信息:{}",businessSources);
       MqttServerConfigModel mqttServerConfigModels = mapper.selectOne(Wrappers.<MqttServerConfigModel>lambdaQuery().eq(MqttServerConfigModel::getIsDeleted, 0)
               .eq(MqttServerConfigModel::getBusinessSources,businessSources));
        LOGGER.info("查询mqtt服务配置信息结果：{}", mqttServerConfigModels);
      return mqttServerConfigModels;
    }

    public List<String> getbusinessSourcesList() {
        QueryWrapper<MqttServerConfigModel> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("distinct business_sources");
        LambdaQueryWrapper<MqttServerConfigModel> distinctDbName =
                queryWrapper.lambda()
                        .eq(MqttServerConfigModel::getIsDeleted, 0);
        List<MqttServerConfigModel> mqttServerConfigModels = mapper.selectList(distinctDbName);
        if (CollectionUtils.isNotEmpty(mqttServerConfigModels)) {
            return mqttServerConfigModels.stream().map(MqttServerConfigModel::getBusinessSources)
                    .collect(Collectors.toList());
        } else {
            return Lists.newArrayList();
        }
    }
}
