/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ExpireRuleDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.client.request.ExpireRuleReq;
import com.digiwin.athena.cdme.service.client.response.ExpireRuleRes;
import com.digiwin.athena.cdme.service.facade.rulesync.IExpireRuleFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.RuleSyncFacadeProxy;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="cdmeExpireRuleFacadeService")
public class ExpireRuleFacadeService
implements IExpireRuleFacadeService {
    private final RuleSyncFacadeProxy ruleSyncFacadeProxy;
    private final IThemeMapClient themeMapClient;
    private final IMonitorRuleCdcService monitorRuleCdcService;

    public ExpireRuleFacadeService(RuleSyncFacadeProxy ruleSyncFacadeProxy, IThemeMapClient themeMapClient, IMonitorRuleCdcService monitorRuleCdcService) {
        this.ruleSyncFacadeProxy = ruleSyncFacadeProxy;
        this.themeMapClient = themeMapClient;
        this.monitorRuleCdcService = monitorRuleCdcService;
    }

    @Override
    public void processedExpireRule(ExpireRuleDto ruleExpireDto) {
        ExpireRuleRes expireRules = this.getExpireRules(ruleExpireDto);
        if (CollectionUtil.isEmpty(expireRules.getRuleIds())) {
            return;
        }
        ArrayList monitorRules = new ArrayList();
        expireRules.getRuleIds().forEach(ruleId -> {
            List<MonitorRuleCdcModel> monitorRuleCdcModels = this.monitorRuleCdcService.listByRuleIdAndTenantId((String)ruleId, expireRules.getTenantId());
            if (CollectionUtil.isNotEmpty(monitorRuleCdcModels)) {
                monitorRules.addAll(monitorRuleCdcModels);
            }
        });
        if (CollectionUtil.isEmpty(monitorRules)) {
            return;
        }
        monitorRules.forEach(monitorRule -> {
            EocDto eocDto = new EocDto(monitorRule.getEocCompanyId(), monitorRule.getEocSiteId(), null);
            SyncRuleParamDto syncRuleParamDto = new SyncRuleParamDto(expireRules.getTenantId(), monitorRule.getRuleId(), "cdmeDELETED", eocDto, "", "");
            this.ruleSyncFacadeProxy.syncMonitorRuleHandler(syncRuleParamDto);
        });
    }

    private ExpireRuleRes getExpireRules(ExpireRuleDto ruleExpireDto) {
        return this.themeMapClient.getExpireRule(new ExpireRuleReq(ruleExpireDto.getTenantId(), ruleExpireDto.getAppCode(), ruleExpireDto.getEventType()));
    }
}

