package com.digiwin.athena.cdme.pojo.dto;

import com.digiwin.athena.cdme.JsonUtil;

/**
 * @description: 侦测引擎响应对象
 * @author: renwm
 * @date: 2020/4/27 10:16
 */
public class ResultDto<T> {

    private String code;
    /**服务返回的消息 */
    private String message;

    private boolean success;

    private T data;

    public ResultDto() {
    }

    public ResultDto(boolean success) {
        this.success = success;
    }

    public ResultDto(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    public ResultDto(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }

    public ResultDto(boolean success, String code, String message, T... data) {
        this.success = success;
        this.message = message;
        this.code = code;
        this.data = null != data && data.length > 0 ? data[0] : null;
    }

    public String getMessage() {
        return message;
    }

    public boolean getSuccess() {
        return success;
    }

    public T getData() {
        return data;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
