package com.digiwin.athena.cdme.service.srp.db;

import com.digiwin.athena.cdme.core.base.IRepositoryService;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;

import java.util.List;

/**
 * @author zhangww
 * @description: CDC侦测
 * @date 2023/3/23 15:32
 */
public interface IMonitorRuleCdcService extends IRepositoryService<MonitorRuleCdcModel> {

    List<MonitorRuleCdcModel> getByTenantIdAndTableAndChangeType(String tenantId, String tableName,
        String changeType);

    List<MonitorRuleCdcModel> getByTenantSidAndTableAndChangeType(String tenantSid,
        String tableName, String changeType);

    /**
     * 根据 ruleId tenantId eocMap删除规则
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    boolean deleteByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto);

    MonitorRuleCdcModel getByRuleIdAndTenantIdAndEoc(String ruleId, String tenantId, EocDto eocDto);
    MonitorRuleCdcModel getByRuleIdAndTenantIdAndEocUnStatus(String ruleId, String tenantId,
        EocDto eocDto);

    MonitorRuleCdcModel queryCdcRuleDetailByRuleIdAndTenantId(String ruleId, String tenantId,
        EocDto eocDto);

    List<MonitorRuleCdcModel> listByRuleIdAndTenantId(String ruleId, String tenantId);

    List<MonitorRuleCdcModel> getAllRules();

    List<MonitorRuleCdcModel> getByCategory(String category, String dbName);

    /***
     * 通过dbname批量获取对应侦测数据
     * @param
     * @return
     */
    List<MonitorRuleCdcModel> getListByCategory(String category);

    /***
     * 通过分类获取对应dbname
     * @param category
     * @return
     */
    List<MonitorRuleCdcModel> getDbNameListByCategory(String category);

    void queryCdcRuleByTenantIdAndTableAndOp(List<MonitorRuleCdcModel> monitorRuleCdcModelList,
        String tenantId, String db, String tableName, String changeType);
}
