/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.TimeRangeDto;
import com.digiwin.athena.cdme.pojo.dto.parse.DynamicParamDto;
import com.digiwin.athena.cdme.pojo.dto.parse.DynamicRuleDto;
import com.digiwin.athena.cdme.pojo.dto.parse.StaticParamDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.request.DataChangeSqlGetParameter;
import com.digiwin.athena.cdme.service.client.request.EspSdkReq;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MonitorHelper {
    private MonitorHelper() {
    }

    public static boolean isGoOn(String category, String monitorRule) {
        if ("cdmeSCHEDULE".equals(category)) {
            return true;
        }
        return "true".equals(JsonUtil.getObject(monitorRule).getString("is_continue"));
    }

    public static boolean isPollingIds(String monitorRule) {
        return "true".equals(JsonUtil.getObject(monitorRule).getString("is_polling_ids"));
    }

    public static boolean isResultFail(ResultDto result) {
        return !result.getSuccess();
    }

    public static Map<String, Object> buildExecutionParam(MonitorRuleModel ruleModel, EocDto eocDto, JSONArray monitorData, Map<String, JSONObject> allParams, String buildType) {
        HashMap sysParam = new HashMap(4);
        String actionId = "";
        List paras = new List();
        if ("monitorAction".equals(buildType)) {
            actionId = ruleModel.getMonitorActionId();
            HashMap parameter = new HashMap(8);
            allParams.forEach((key, value) -> {
                boolean isContains = Arrays.asList(value.getString("target").split(",")).contains("MONITOR_ACTION");
                if (isContains) {
                    parameter.put(key, value.getString("value"));
                }
            });
            paras = Collections.singletonList(parameter);
        } else if ("action".equals(buildType)) {
            allParams.forEach((key, value) -> {
                boolean isContains = Arrays.asList(value.getString("target").split(",")).contains("ACTION");
                if (isContains) {
                    sysParam.put(key, value.getString("value"));
                }
            });
            actionId = ruleModel.getActionId();
            paras = monitorData;
        }
        HashMap<String, Object> executionParams = new HashMap<String, Object>(8);
        executionParams.put("sysParam", sysParam);
        executionParams.put("actionId", actionId);
        executionParams.put("paras", paras);
        executionParams.put("tenantId", ruleModel.getTenantId());
        executionParams.put("eocMap", eocDto.toUnderLineMap());
        return executionParams;
    }

    public static Map<String, Object> buildCdcExecutionParam(MonitorRuleCdcModel monitorRuleCdcModel, EocDto eocDto, JSONArray monitorData) {
        HashMap<String, Object> executionParams = new HashMap<String, Object>(8);
        executionParams.put("actionId", monitorRuleCdcModel.getActionId());
        executionParams.put("paras", monitorData);
        executionParams.put("tenantId", monitorRuleCdcModel.getTenantId());
        executionParams.put("eocMap", eocDto.toUnderLineMap());
        return executionParams;
    }

    public static String buildRedisKey(MonitorRuleModel ruleModel, EocDto eocDto) {
        return MonitorHelper.buildRedisKey(ruleModel.getTenantId(), ruleModel.getRuleId(), eocDto.getEocCompanyId(), eocDto.getEocSiteId(), ruleModel.getProductName());
    }

    public static String buildRedisKey(String tenantId, String ruleId, EocDto eocDto) {
        return MonitorHelper.buildRedisKey(tenantId, ruleId, eocDto.getEocCompanyId(), eocDto.getEocSiteId(), "");
    }

    public static String buildOldRedisKey(String tenantId, String ruleId, EocDto eocDto) {
        return "monitor-" + tenantId + "-" + ruleId + "-" + StringUtil.nullToEmpty(eocDto.getEocCompanyId()) + "-" + StringUtil.nullToEmpty(eocDto.getEocSiteId()) + "-";
    }

    public static String buildRedisKey(String tenantId, String ruleId, String eocCompanyId, String eocSiteId, String productName) {
        return "monitor:" + tenantId + ":" + ruleId + ":" + StringUtil.nullToEmpty(eocCompanyId) + ":" + StringUtil.nullToEmpty(eocSiteId) + ":" + productName;
    }

    public static String buildCrossLevelRedisKey(MonitorRuleModel ruleModel, EocDto eocDto) {
        return MonitorHelper.buildRedisKey(ruleModel.getTenantId(), ruleModel.getRuleId(), eocDto.getEocCompanyId(), eocDto.getEocSiteId(), ruleModel.getProductName());
    }

    public static String buildLockKey(MonitorRuleModel ruleModel) {
        return ruleModel.getTenantId() + ":" + ruleModel.getRuleId() + ":" + StringUtil.nullToEmpty(ruleModel.getEocCompanyId()) + ":" + StringUtil.nullToEmpty(ruleModel.getEocSiteId()) + ":" + ruleModel.getProductName();
    }

    public static String buildOldLockKey(MonitorRuleModel ruleModel) {
        return ruleModel.getTenantId() + "-" + ruleModel.getRuleId() + "-" + StringUtil.nullToEmpty(ruleModel.getEocCompanyId()) + "-" + StringUtil.nullToEmpty(ruleModel.getEocSiteId()) + "-" + ruleModel.getProductName();
    }

    public static String buildIntervelLimitKey(MonitorRuleModel ruleModel) {
        return "monitoring:" + ruleModel.getTenantId() + ":" + ruleModel.getRuleId() + ":" + StringUtil.nullToEmpty(ruleModel.getEocCompanyId()) + ":" + StringUtil.nullToEmpty(ruleModel.getEocSiteId()) + ":" + ruleModel.getProductName();
    }

    public static String buildCdcRuleKey(String tenantId, String db, String tableName, String changeType) {
        return "cdme-cdc:" + tenantId + ":" + db + ":" + tableName + ":" + changeType;
    }

    public static String buildCdcRuleSubKey(MonitorRuleCdcModel ruleCdcModel) {
        return ruleCdcModel.getRuleId() + ":" + StringUtil.nullToEmpty(ruleCdcModel.getEocCompanyId()) + ":" + StringUtil.nullToEmpty(ruleCdcModel.getEocSiteId());
    }

    public static String buildCdcTopicRouteKey(String topicName, String groupName) {
        return "monitorCDC_TopicRelationship:" + topicName + ":" + groupName;
    }

    public static String buildCdcTsid(String tenantsid) {
        return "monitorCDC_TSID:" + tenantsid;
    }

    public static String getDate(String dateTime) {
        return dateTime.substring(0, 7).replace('-', '_');
    }

    public static int calculateWeight(EocDto eocDto) {
        return eocDto == null ? 0 : eocDto.calculateWeight();
    }

    public static Map<String, JSONObject> parseDynamicParams(JSONObject ruleObject, String category, TimeRangeDto timeRange) {
        HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
        JSONArray dynamicParams = ruleObject.getJSONArray("dynamic_params");
        if (CollectionUtil.isEmpty((Collection)dynamicParams)) {
            return resultMap;
        }
        List dynamicParamDtos = dynamicParams.toJavaList(DynamicParamDto.class);
        for (DynamicParamDto paramDto : dynamicParamDtos) {
            LocalDateTime referTime;
            String sourceName = paramDto.getSourceName();
            if (StringUtil.isBlank(sourceName)) {
                throw new BusinessException(ErrorCodeEnum.DYNAMIC_RULE_CONFIG_ERR);
            }
            if (sourceName.equals("last_monitor_time")) {
                referTime = timeRange.getStartTime();
            } else if (sourceName.equals("monitor_time")) {
                referTime = timeRange.getEndTime();
            } else {
                throw new BusinessException(ErrorCodeEnum.DYNAMIC_RULE_CONFIG_ERR);
            }
            DynamicRuleDto ruleDto = paramDto.getRule();
            JSONObject valObject = new JSONObject();
            if (null != ruleDto && StringUtil.isNotBlank(ruleDto.getPeriod())) {
                String dateType = paramDto.getParamType() + "_" + ruleDto.getTimeType();
                String tempVal = LocalTimeUtil.getDateTime(referTime, ruleDto.getPeriod(), ruleDto.getRange(), ruleDto.getDay(), ruleDto.getAddDay(), dateType);
                tempVal = MonitorHelper.formatDateByConfig(tempVal, ruleDto.getFomart());
                valObject.put("value", (Object)StringUtil.nullToEmpty(tempVal));
            } else if (null != ruleDto && StringUtil.isNotBlank(ruleDto.getFomart())) {
                valObject.put("value", (Object)MonitorHelper.formatDateByConfig(referTime, ruleDto.getFomart()));
            } else {
                String tmp = null == referTime ? null : referTime.format(LocalTimeUtil.DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS);
                valObject.put("value", (Object)tmp);
            }
            valObject.put("target", (Object)MonitorHelper.parseParamTarget(category, paramDto.getParamTarget()));
            if ("cdmeSCAN".equals(category) || "cdmeSQL_SCRIPT".equals(category)) {
                valObject.put("type", (Object)paramDto.getParamType());
            }
            resultMap.put(paramDto.getParamName(), valObject);
        }
        return resultMap;
    }

    public static Map<String, JSONObject> parseStaticParams(JSONObject ruleObject, String category) {
        HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
        JSONArray staticParams = ruleObject.getJSONArray("static_params");
        if (CollectionUtil.isEmpty((Collection)staticParams)) {
            return resultMap;
        }
        staticParams.toJavaList(StaticParamDto.class).forEach(dto -> {
            JSONObject tempObject = new JSONObject();
            tempObject.put("value", (Object)dto.getParamValue());
            tempObject.put("target", (Object)MonitorHelper.parseParamTarget(category, dto.getParamTarget()));
            resultMap.put(dto.getParamName(), tempObject);
        });
        return resultMap;
    }

    private static String formatDateByConfig(String time, String format) {
        if (StringUtil.isBlank(format) || StringUtil.isBlank(time)) {
            return time;
        }
        DateTimeFormatter dateTimeFormatter = time.length() > 10 ? LocalTimeUtil.DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS : LocalTimeUtil.DATE_FORMATTER;
        LocalDateTime temp = LocalDateTime.parse(time, dateTimeFormatter);
        return temp.format(DateTimeFormatter.ofPattern(format));
    }

    private static String formatDateByConfig(LocalDateTime time, String format) {
        if (null == time) {
            return null;
        }
        return time.format(DateTimeFormatter.ofPattern(format));
    }

    private static String parseParamTarget(String category, String paramTarget) {
        if (StringUtil.isNotBlank(paramTarget)) {
            return paramTarget;
        }
        if ("cdmeAPI".equals(category)) {
            return "MONITOR_ACTION";
        }
        if ("cdmeSCAN".equals(category)) {
            return "SCAN";
        }
        return "";
    }

    public static JSONArray transformToDynamicCondition(Map<String, JSONObject> allParam) {
        JSONArray condition = new JSONArray();
        allParam.forEach((k, v) -> {
            JSONObject valObject = new JSONObject();
            valObject.put("name", k);
            valObject.put("type", (Object)v.getString("type"));
            valObject.put("value", (Object)v.getString("value"));
            condition.add((Object)valObject);
        });
        return condition;
    }

    public static EspSdkReq buildDataChangeSqlGetRequest(String ruleId, String tenantId, String productName, JSONArray dynamicConditions, JSONObject rule, EocDto eocDto) {
        DataChangeSqlGetParameter sqlGetParameter = new DataChangeSqlGetParameter();
        JSONArray ruleArray = new JSONArray();
        JSONObject ruleParameter = new JSONObject();
        rule.fluentRemove((Object)"dynamic_params").fluentRemove((Object)"static_params").fluentRemove((Object)"is_continue").fluentRemove((Object)"is_polling_ids").fluentRemove((Object)"is_deduplication").fluentRemove((Object)"bk_info").fluentRemove((Object)"return_columns").fluentRemove((Object)"eocLevel").fluentRemove((Object)"join_params").fluentRemove((Object)"alias").fluentRemove((Object)"table").fluentRemove((Object)"monitor_type").fluentRemove((Object)"dynamic_condition");
        ruleParameter.putAll((Map)rule);
        ruleParameter.put("script", (Object)Base64.getEncoder().encodeToString(rule.getString("script").getBytes()));
        ruleParameter.put("rule_id", (Object)ruleId);
        ruleParameter.put("dynamic_condition", (Object)dynamicConditions);
        ruleArray.add((Object)ruleParameter);
        sqlGetParameter.setRules(ruleArray);
        return new EspSdkReq<DataChangeSqlGetParameter>(tenantId, eocDto, productName, sqlGetParameter, ruleId, "data.change.sql.get");
    }

    public static String getChangeType(String op) {
        if ("u".equals(op)) {
            return "update";
        }
        if ("c".equals(op)) {
            return "create";
        }
        return "delete";
    }
}

