/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import com.digiwin.athena.cdme.service.facade.detection.data.IProcessDetectionService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeAPI")
public class ApiDetectionService
implements IProcessDetectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDetectionService.class);
    private final IExecutionClient executionClient;

    public ApiDetectionService(IExecutionClient executionClient) {
        this.executionClient = executionClient;
    }

    @Override
    public ResultDto<JSONArray> processDetection(Map<String, JSONObject> allParam, DetectionRequestDto requestDto) {
        MonitorRuleModel ruleModel = requestDto.getRuleModel();
        Map<String, Object> monitorActionParam = MonitorHelper.buildExecutionParam(ruleModel, requestDto.getEoc(), null, allParam, "monitorAction");
        LOGGER.info("API\u7c7b\u578b\u4fa6\u6d4b\u53d1\u8d77Monitor Action\u5f00\u59cb*************");
        ResultDto<JSON> monitorActionResult = this.executionClient.callExecution(monitorActionParam, false);
        LOGGER.info("API\u7c7b\u578b\u4fa6\u6d4b\u53d1\u8d77Monitor Action\u7ed3\u675f*************");
        if (MonitorHelper.isResultFail(monitorActionResult)) {
            return ResultHelper.generateFailResult(monitorActionResult.getCode(), monitorActionResult.getMessage(), new JSONArray[0]);
        }
        if (null != monitorActionResult.getData() && MonitorHelper.isPollingIds(ruleModel.getMonitorRule())) {
            JSONObject data = (JSONObject)monitorActionResult.getData();
            return ResultHelper.generateSuccessResult(data.getJSONArray("change_objects"));
        }
        JSONArray tmp = null;
        if (monitorActionResult.getData() instanceof JSONArray) {
            tmp = (JSONArray)monitorActionResult.getData();
        } else {
            tmp = new JSONArray();
            tmp.add((Object)monitorActionResult.getData());
        }
        return ResultHelper.generateSuccessResult(tmp);
    }
}

