/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.repository.dao.CdmeMonitorDupMapper;
import com.digiwin.athena.cdme.repository.model.MonitorDupModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorDupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeMonitorDupService")
public class MonitorDupService
extends AbstractRepositorService<CdmeMonitorDupMapper, MonitorDupModel>
implements IMonitorDupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorDupService.class);

    public MonitorDupService(CdmeMonitorDupMapper mapper) {
        super(mapper);
    }

    @Override
    public MonitorDupModel getByRuleIdAndTenantIdAndProdAndEocmap(String ruleId, String tenantId, String productName, EocDto eocDto) {
        return (MonitorDupModel)((CdmeMonitorDupMapper)this.mapper).selectOne((Wrapper)this.queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto).eq(MonitorDupModel::getProductName, (Object)productName));
    }

    @Override
    public boolean editByRuleIdAndTenantIdAndProdAndEocmap(MonitorDupModel dupModel) {
        String eocCompanyId = dupModel.getEocCompanyId();
        String eocSiteId = dupModel.getEocSiteId();
        int result = ((CdmeMonitorDupMapper)this.mapper).update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(MonitorDupModel::getRuleId, (Object)dupModel.getRuleId())).eq(MonitorDupModel::getTenantId, (Object)dupModel.getTenantId())).eq(MonitorDupModel::getProductName, (Object)dupModel.getProductName())).eq(StringUtil.isNotBlank(eocCompanyId), MonitorDupModel::getEocCompanyId, (Object)eocCompanyId)).eq(StringUtil.isNotBlank(eocSiteId), MonitorDupModel::getEocSiteId, (Object)eocSiteId)).set(MonitorDupModel::getCacheValue, (Object)dupModel.getCacheValue()));
        if (result < 1) {
            LOGGER.error("sd_monitor_dup\u8868\u66f4\u65b0\u7f13\u5b58\u5931\u8d25\uff0ccacheValue:{}, ruleId:{},tenantId:{},productName:{},eocCompanyId:{},eocSiteId:{}", new Object[]{dupModel.getCacheValue(), dupModel.getRuleId(), dupModel.getTenantId(), dupModel.getProductName(), dupModel.getEocCompanyId(), dupModel.getEocSiteId()});
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteByRuleIdAndTenantIdAndEocmap(String ruleId, String tenantId, EocDto eocDto) {
        int result = ((CdmeMonitorDupMapper)this.mapper).delete((Wrapper)this.queryWrapperByRuleIdAndTenantIdAndEocmap(ruleId, tenantId, eocDto));
        if (result < 1) {
            LOGGER.error("sd_monitor_dup\u8868\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u6761\u4ef6ruleId:{},tenantId:{},eocDto:{}", new Object[]{ruleId, tenantId, eocDto});
            return false;
        }
        return true;
    }

    private LambdaQueryWrapper<MonitorDupModel> queryWrapperByRuleIdAndTenantIdAndEocmap(String ruleId, String tenantId, EocDto eocDto) {
        String eocCompanyId = eocDto.getEocCompanyId();
        String eocSiteId = eocDto.getEocSiteId();
        return (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MonitorDupModel::getRuleId, (Object)ruleId)).eq(MonitorDupModel::getTenantId, (Object)tenantId)).eq(StringUtil.isNotBlank(eocCompanyId), MonitorDupModel::getEocCompanyId, (Object)eocCompanyId)).eq(StringUtil.isNotBlank(eocSiteId), MonitorDupModel::getEocSiteId, (Object)eocSiteId);
    }
}

