/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.db.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.cdme.repository.dao.CdmeMqttServerConfigMapper;
import com.digiwin.athena.cdme.repository.model.MqttServerConfigModel;
import com.digiwin.athena.cdme.service.srp.db.AbstractRepositorService;
import com.digiwin.athena.cdme.service.srp.db.IMqttServerConfigService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cdmeMqttServerConfigService")
public class MqttServerConfigService
extends AbstractRepositorService<CdmeMqttServerConfigMapper, MqttServerConfigModel>
implements IMqttServerConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttServerConfigService.class);

    public MqttServerConfigService(CdmeMqttServerConfigMapper mapper) {
        super(mapper);
    }

    @Override
    public List<MqttServerConfigModel> getServerList() {
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2mqtt\u670d\u52a1\u914d\u7f6e\u4fe1\u606f");
        List mqttServerConfigModels = ((CdmeMqttServerConfigMapper)this.mapper).selectList((Wrapper)Wrappers.lambdaQuery().eq(MqttServerConfigModel::getIsDeleted, (Object)0));
        LOGGER.info("\u67e5\u8be2mqtt\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)mqttServerConfigModels);
        if (CollectionUtils.isNotEmpty((Collection)mqttServerConfigModels)) {
            return mqttServerConfigModels;
        }
        return Lists.newArrayList();
    }

    @Override
    public MqttServerConfigModel getServerListByBusinessSources(String businessSources) {
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2mqtt\u670d\u52a1\u914d\u7f6e\u4fe1\u606f:{}", (Object)businessSources);
        MqttServerConfigModel mqttServerConfigModels = (MqttServerConfigModel)((CdmeMqttServerConfigMapper)this.mapper).selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MqttServerConfigModel::getIsDeleted, (Object)0)).eq(MqttServerConfigModel::getBusinessSources, (Object)businessSources));
        LOGGER.info("\u67e5\u8be2mqtt\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)mqttServerConfigModels);
        return mqttServerConfigModels;
    }

    @Override
    public List<String> getbusinessSourcesList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"distinct business_sources"});
        LambdaQueryWrapper distinctDbName = (LambdaQueryWrapper)queryWrapper.lambda().eq(MqttServerConfigModel::getIsDeleted, (Object)0);
        List mqttServerConfigModels = ((CdmeMqttServerConfigMapper)this.mapper).selectList((Wrapper)distinctDbName);
        if (CollectionUtils.isNotEmpty((Collection)mqttServerConfigModels)) {
            return mqttServerConfigModels.stream().map(MqttServerConfigModel::getBusinessSources).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

