package com.digiwin.athena.cdme.core.config;

import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ConsumerAwareListenerErrorHandler;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangww
 * @description:
 * @date 2023/3/25 21:54
 */
@Configuration
@EnableKafka
public class CdmeKafkaConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(CdmeKafkaConfig.class);

    @Bean("cdmeConsumerFactory")
    public ConsumerFactory<Integer, String> cdmeConsumerFactory() {
        return new DefaultKafkaConsumerFactory<>(cdmeConsumerConfigs());
    }

    @Bean("cdmeConsumerConfigs")
    public Map<String, Object> cdmeConsumerConfigs() {
        Map<String, Object> props = new HashMap<>();
        props.put(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG, ConfigConstant.KAFKA_SERVERS);
        props.put(ConsumerConfig.ENABLE_AUTO_COMMIT_CONFIG, false);
        props.put(ConsumerConfig.ISOLATION_LEVEL_CONFIG, "read_committed");
        props.put(ConsumerConfig.KEY_DESERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringDeserializer");
        props.put(ConsumerConfig.VALUE_DESERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringDeserializer");
        return props;
    }

    @Bean("cdmeConsumerAwareErrorHandler")
    public ConsumerAwareListenerErrorHandler cdmeConsumerAwareErrorHandler() {
        return (message, e, consumer) -> {
            LOGGER.error("侦测引擎CDC消息处理异常:[{}]", message.getPayload().toString());
            return null;
        };
    }

    @Bean("kafkaListenerContainerFactory")
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory<Integer, String> factory = new ConcurrentKafkaListenerContainerFactory<>();
        factory.setConsumerFactory(cdmeConsumerFactory());
        factory.setConcurrency(5);
        factory.getContainerProperties().setPollTimeout(30000);
        factory.setAckDiscarded(true);
        factory.getContainerProperties().setAckMode(AbstractMessageListenerContainer.AckMode.MANUAL_IMMEDIATE);
        return factory;
    }


}