package com.digiwin.athena.cdme.core.config;

import com.digiwin.athena.cdme.core.util.StringUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/7/8 15:14
 */
@Configuration
public class CdmeRedissonConfig {

    @Value("${spring.redis.host}")
    private String host;

    @Value("${spring.redis.port}")
    private String port;

    @Value("${spring.redis.password}")
    private String password;

    @Value("${spring.redis.database}")
    private int database;

    @Value("${spring.redis.timeout}")
    private int connectTimeout;

    @Value("${spring.redis.lettuce.pool.min-idle}")
    private int connectionMinIdleSize;

    @Value("${spring.redis.lettuce.pool.max-active}")
    private int connectionPoolMaxActive;

    @Bean("cdmeRedissonClient")
    public RedissonClient redissonClient() {
        Config config = new Config();
        /** FIXME 目前redis是单机部署，如果修改部署方式，此处要同步修改 */
        config.useSingleServer().setAddress("redis://" + host + ":" + port)
                                .setDatabase(database)
                                /** 连接任何Redis服务器时超时 */
                                .setConnectTimeout(connectTimeout)
                                /** 最小空闲Redis连接数 */
                                .setConnectionMinimumIdleSize(connectionMinIdleSize)
                                /** Redis连接池最大连接数 */
                                .setConnectionPoolSize(connectionPoolMaxActive);
        if (StringUtil.isBlank(password)) {
            config.useSingleServer().setPassword(null);
        } else {
            config.useSingleServer().setPassword(password);
        }
        return Redisson.create(config);
    }
}
