package com.digiwin.athena.cdme.provider;

import com.digiwin.athena.cdme.pojo.vo.RuleInfoVO;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/11/22 13:29
 */
@Service("cdmeRuleInfoService")
public class RuleInfoService implements IRuleInfoService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RuleInfoService.class);

    private final IMonitorRuleCdcService ruleService;

    public RuleInfoService(IMonitorRuleCdcService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    public List<RuleInfoVO> queryAll() {
        List<MonitorRuleCdcModel> ruleModels = ruleService.getAllRules();
        if (CollectionUtils.isEmpty(ruleModels)) {
            return null;
        }
        return ruleModels.stream().map(rule -> new RuleInfoVO(rule.getRuleId(), rule.getTenantId(), rule.getEocCompanyId(), rule.getEocSiteId(), rule.getValid()))
                .collect(Collectors.toList());
    }
}
