package com.digiwin.athena.cdme.repository.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;

import java.time.LocalDateTime;

/**
 * @description: 侦测死信队列实体类
 * @author: dongwh
 * @date: 2020/7/21 15:28
 */
@TableName("sd_monitor_deadletter")
public class MonitorDeadLetterModel {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 死信消息内容
     */
    private String content;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 死信类型
     */
    private String type;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MonitorDeadLetterModel() {
    }

    public MonitorDeadLetterModel(String content, String type) {
        this.content = content;
        this.createTime = LocalTimeUtil.now();
        this.type = type;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
