/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.config;

import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ConsumerAwareListenerErrorHandler;

@Configuration
@EnableKafka
public class CdmeKafkaConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdmeKafkaConfig.class);

    @Bean(value={"cdmeConsumerFactory"})
    public ConsumerFactory<Integer, String> cdmeConsumerFactory() {
        return new DefaultKafkaConsumerFactory(this.cdmeConsumerConfigs());
    }

    @Bean(value={"cdmeConsumerConfigs"})
    public Map<String, Object> cdmeConsumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", ConfigConstant.KAFKA_SERVERS);
        props.put("enable.auto.commit", false);
        props.put("isolation.level", "read_committed");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        return props;
    }

    @Bean(value={"cdmeConsumerAwareErrorHandler"})
    public ConsumerAwareListenerErrorHandler cdmeConsumerAwareErrorHandler() {
        return (message, e, consumer) -> {
            LOGGER.error("\u4fa6\u6d4b\u5f15\u64ceCDC\u6d88\u606f\u5904\u7406\u5f02\u5e38:[{}]", (Object)message.getPayload().toString());
            return null;
        };
    }

    @Bean(value={"kafkaListenerContainerFactory"})
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.cdmeConsumerFactory());
        factory.setConcurrency(Integer.valueOf(5));
        factory.getContainerProperties().setPollTimeout(30000L);
        factory.setAckDiscarded(Boolean.valueOf(true));
        factory.getContainerProperties().setAckMode(AbstractMessageListenerContainer.AckMode.MANUAL_IMMEDIATE);
        return factory;
    }
}

