/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.mq.consumer.monitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorFacadeService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component(value="cdmeMonitorTransferMoscCdcListener")
public class MonitorTransferMoscCdcListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTransferMoscCdcListener.class);
    private final IMonitorFacadeService monitorFacadeService;

    public MonitorTransferMoscCdcListener(IMonitorFacadeService monitorFacadeService) {
        this.monitorFacadeService = monitorFacadeService;
    }

    @KafkaListener(topics={"BM_MOSC_CDC"}, groupId="CDME", containerFactory="kafkaListenerContainerFactory", errorHandler="cdmeConsumerAwareErrorHandler")
    public void consumeMonitorMsg(ConsumerRecord<?, ?> record, Acknowledgment ack) {
        LOGGER.info("\u4fa6\u6d4b\u5f15\u64ce\u63a5\u6536CDC\u7684\u8f6c\u53d1\u6d88\u606f\u6765\u81eaMOSC Topic\u4e3a:[{}]", record.value());
        JSONObject recordJsonObject = JSON.parseObject((String)String.valueOf(record.value()));
        ResultDto resultDto = this.monitorFacadeService.executeDeliver(recordJsonObject);
        if (resultDto.getSuccess()) {
            ack.acknowledge();
        }
    }
}

