package com.digiwin.athena.cdme.pojo.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.LocalDateTimeConverter;
import com.google.gson.annotations.JsonAdapter;

import java.time.LocalDateTime;

/**
 * @description: 侦测查询服务接口返回的侦测详细信息
 * @author: dongwh
 * @date: 2020/11/5 10:44
 */
public class MonitorOpsDetailVo {
    /** 规则名称 */
    private String ruleId;
    /** 租戶名称 */
    private String tenantId;
    /** 侦测规则类型 */
    private String category;
    /** trigger_id */
    private String triggerId;
    /** 创建时间 */
    @JsonAdapter(LocalDateTimeConverter.class)
    private LocalDateTime createTime;
    /** 侦测规则状态：是否可用 */
    private String isEnable;
    /** 排程实例启停状态：启用/停用，若未找到实例，报未找到实例错误 */
    private String scheduleInstanceStatus;
    /** 规则状态更新时间 */
    @JsonAdapter(LocalDateTimeConverter.class)
    private LocalDateTime updateTime;
    /** 侦测产品类型 */
    private String productName;
    /** 触发间隔描述 */
    private String triggerParam;
    /**  最后一次侦测时间 */
    @JsonAdapter(LocalDateTimeConverter.class)
    private LocalDateTime lastMonitorTime;
    /** 侦测状态 */
    private String monitorStatus;
    /** 流程状态 */
    private String actionStatus;
    /** 侦测执行结果 */
    private String actionResult;
    /** eoc公司ID */
    private String eocCompanyId;
    /** eoc工厂ID */
    private String eocSiteId;

    @JSONField(name = "规则id")
    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @JSONField(name = "租户")
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JSONField(name = "侦测规则类型")
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @JSONField(name = "排程id")
    public String getTriggerId() {
        return triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    @JSONField(name = "创建时间")
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @JSONField(name = "侦测规则是否可用")
    public String getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(String isEnable) {
        this.isEnable = isEnable;
    }

    @JSONField(name = "排程实例启停状态")
    public String getScheduleInstanceStatus() {
        return scheduleInstanceStatus;
    }

    public void setScheduleInstanceStatus(String scheduleInstanceStatus) {
        this.scheduleInstanceStatus = scheduleInstanceStatus;
    }

    @JSONField(name = "规则状态更新时间")
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @JSONField(name = "侦测产品类型")
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @JSONField(name = "触发间隔描述")
    public String getTriggerParam() {
        return triggerParam;
    }

    public void setTriggerParam(String triggerParam) {
        this.triggerParam = triggerParam;
    }

    @JSONField(name = "侦测触发时间")
    public LocalDateTime getLastMonitorTime() {
        return lastMonitorTime;
    }

    public void setLastMonitorTime(LocalDateTime lastMonitorTime) {
        this.lastMonitorTime = lastMonitorTime;
    }

    @JSONField(name = "侦测状态")
    public String getMonitorStatus() {
        return this.monitorStatus;
    }

    public void setMonitorStatus(String monitorStatus) {
        this.monitorStatus = monitorStatus;
    }

    @JSONField(name = "流程状态")
    public String getActionStatus() {
        return this.actionStatus;
    }

    public void setActionStatus(String actionStatus) {
        this.actionStatus = actionStatus;
    }

    @JSONField(name = "侦测执行结果")
    public String getActionResult() {
        return actionResult;
    }

    public void setActionResult(String actionResult) {
        this.actionResult = actionResult;
    }

    @JSONField(name = "eoc公司ID")
    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    @JSONField(name = "eoc工厂ID")
    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}