package com.digiwin.athena.cdme.repository.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;

/**
 * @description: 去重对应的redis的key值记录表
 * @author: dongwh
 * @date: 2020/11/10 19:18
 */
@TableName("sd_monitor_dup")
public class MonitorDupModel {
    /** 主键ID */
    @TableId(type = IdType.AUTO)
    private String id;
    /** 规则ID */
    private String ruleId;
    /** 租户ID */
    private String tenantId;
    /** 地端erp产品名称 */
    private String productName;
    /** eoc公司ID */
    private String eocCompanyId;
    /** eoc工厂ID */
    private String eocSiteId;
    /**redis的key值对应的value */
    private String cacheValue;

    public MonitorDupModel() {
    }

    public MonitorDupModel(String tenantId, String ruleId, String eocCompanyId, String eocSiteId, String productName, String cacheValue) {
        this.tenantId = tenantId;
        this.ruleId = ruleId;
        this.eocCompanyId = eocCompanyId;
        this.eocSiteId = eocSiteId;
        this.productName = productName;
        this.cacheValue = cacheValue;
    }

    public MonitorDupModel(MonitorRuleModel ruleModel, EocDto eocDto, String changeObjStr) {
        this.ruleId = ruleModel.getRuleId();
        this.tenantId = ruleModel.getTenantId();
        this.productName = ruleModel.getProductName();
        this.eocCompanyId = StringUtil.nullToEmpty(eocDto.getEocCompanyId());
        this.eocSiteId = StringUtil.nullToEmpty(eocDto.getEocSiteId());
        this.cacheValue = changeObjStr;
    }

    public MonitorDupModel(MonitorRuleModel ruleModel, String eocCompanyId, String eocSiteId, String changeObjStr) {
        this.ruleId = ruleModel.getRuleId();
        this.tenantId = ruleModel.getTenantId();
        this.productName = ruleModel.getProductName();
        this.eocCompanyId = eocCompanyId;
        this.eocSiteId = eocSiteId;
        this.cacheValue = changeObjStr;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getEocCompanyId() {
        return eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getCacheValue() {
        return cacheValue;
    }

    public void setCacheValue(String cacheValue) {
        this.cacheValue = cacheValue;
    }

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}
