package com.digiwin.athena.cdme.service.client.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.cdme.pojo.BaseEntity;

import java.util.List;

/**
 * @description: 调用kg获取过期应用API返回结果
 * @author: dongwh
 * @date: 2022/7/29 10:39
 */
public class ExpireRuleRes extends BaseEntity {

    private String tenantId;

    private String appCode;

    /**
     * 匹配kg返回的过期侦测规则，对应规则中的ruleId
     */
    @JSONField(name = "MonitorRule")
    private List<String> ruleIds;


    public ExpireRuleRes() {
    }

    public ExpireRuleRes(String tenantId, String appCode, List<String> ruleIds) {
        this.tenantId = tenantId;
        this.appCode = appCode;
        this.ruleIds = ruleIds;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public List<String> getRuleIds() {
        return ruleIds;
    }

    public void setRuleIds(List<String> ruleIds) {
        this.ruleIds = ruleIds;
    }
}
