package com.digiwin.athena.cdme.service.facade.ops;

import com.digiwin.athena.cdme.pojo.dto.*;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;

import java.util.List;

/**
 * @description: 规则DB操作
 * @author: liunansheng
 * @date: 2021/12/3 10:52
 */
public interface IRuleTriggerOperatorFacadeService {

    /**
     * 查询规则详情
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    MonitorRuleDto queryRuleDetailByRuleId(String ruleId, String tenantId, EocDto eocDto);

    MonitorCdcRuleDto queryCdcRuleDetailByRuleId(String ruleId, String tenantId, EocDto eocDto);
    public MonitorCdcRuleDto getByRuleIdAndTenantIdAndEocUnStatus(String ruleId, String tenantId,
        EocDto eocDto);
    MonitorCdcRuleDto queryCdcRuleDetailByRuleIdAndTenantId(String ruleId, String tenantId,
        EocDto eocDto);

    /**
     * 查询规则详情，忽略isEnable
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    MonitorCdcRuleDto queryRuleDetailByRuleIdIgnoreIsEnable(String ruleId, String tenantId,
        EocDto eocDto);

    /**
     * 更新lastMonitorTime
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @param backtrackDate
     * @return
     */
    ResultDto<Void> handleBacktrackDate(String ruleId, String tenantId, EocDto eocDto,
        String backtrackDate);

    /**
     * 保存CDC规则
     * @param monitorRuleDto
     * @param eocDto
     * @return
     */
    ResultDto<Void> saveCdcRule(MonitorRuleDto monitorRuleDto, EocDto eocDto);

    /**
     * 修改规则
     * @param monitorRuleDto
     * @return
     */
    ResultDto<Void> modifyRule(MonitorRuleDto monitorRuleDto);

    /**
     * 修改规则
     * @param monitorRuleDto
     * @return
     */
    ResultDto<Void> modifyCdcRule(MonitorCdcRuleDto monitorRuleDto);

    /**
     * 根据租户ruleId和id查询规则
     * @param ruleId
     * @param tenantId
     * @return
     */
    List<MonitorRuleModel> queryRuleByRuleIdAndTenantId(String ruleId, String tenantId);

    /**
     * 删除rule
     * @param ruleDto
     * @param eocDto
     * @return
     */
    ResultDto<Void> deleteRule(MonitorRuleDto ruleDto, EocDto eocDto);

    /**
     * 删除rule
     * @param ruleDto
     * @param eocDto
     * @return
     */
    ResultDto<Void> deleteCdcRule(MonitorCdcRuleDto ruleDto, EocDto eocDto);

    /**
     * 保存ins
     * @param insModel
     * @return
     */
    ResultDto<Void> saveTriggerIns(MonitorTriggerInsModel insModel);

    /**
     * 根据triggerId查询ins
     * @param triggerId
     * @return
     */
    List<MonitorTriggerInsModel> queryTriggerInsByTriggerId(String triggerId);
    /**
     * 查询规则详细信息，包含trigger、ins等
     * @param ruleId
     * @param tenantId
     * @param eocDto
     * @return
     */
    List<RuleOpsDto> listRuleDetailByRuleIdAndEoc(String ruleId, String tenantId, EocDto eocDto);
}
