package com.digiwin.athena.cdme.core.constant;

import com.digiwin.app.autoconfigure.merge.listener.DWMultipleAppEnvApplicationStartingListener;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.DWApplicationPropertiesUtils;

/**
 * @description: Module资源文件配置实体类对象
 * @author: renwm
 * @date: 2020/4/28 09:02
 */
public final class ConfigConstant {
    private ConfigConstant() {
    }

    /**
     * application 资源文件名字
     */
    public static final String APPLICATION_PROPERTIES_NAME = "application";

    /**
     * IAM 用户登录 路径配置
     */
    public static final String IAM_USERLOGINURL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.iamUserLoginUrl");
    /**
     * ThemeMap 域名
     */
    public static final String THEMEMAP_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.themeMap.domain.url");
    /**
     * ThemeMap 获取侦测规则URL
     */
    public static final String THEMEMAP_MONITORRULE_URL = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/MonitorRule/query";
    /**
     * ThemeMap 获取过期应用URL
     */
    public static final String THEMEMAP_EXPIRE_RULE_URL = THEMEMAP_DOMAIN_URL + DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.themeMap.expire.rule");
    /**
     * ThemeMap md5key值
     */
    public static final String THEMEMAP_LICENSEKEY_MD5_KEY = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.themeMap.licenseKey.md5.key");
    /**
     * ThemeMap request from
     */
    public static final String THEMEMAP_LICENSEKEY_REQUEST_FROM = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.themeMap.licenseKey.request.from");

    /**
     * 侦测偏移时长 毫秒
     */
    public static final Long MONITOR_OFFSET_TIME = Long.valueOf(DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.monitorOffsetTime"));

    /**
     * 查询redis接口 MD5加密干扰串
     */
    public static final String REDIS_MD5_KEY = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.redis.md5.interference");
    /**
     * 查询侦测信息接口 MD5加密干扰串
     */
    public static final String MONITOR_INFO_MD5_KEY = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.monitor.info.md5.interference");

    /**
     * 初始化esp-sdk配置信息 start
     */
    public static final String ESP_DOMAIN = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.esp.sdk.esp.domain");

    public static final String MDC_DOMAIN = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.esp.sdk.mdc.domain");

    public static final String TM_DOMAIN = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.esp.sdk.tm.domain");
    public static final String EOC_DOMAIN = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.esp.sdk.eoc.domain");
    /** 初始化esp-sdk配置信息 end */

    /**
     * 更新redis数据失败重试间隔时间 单位秒
     */
    public static final int MONITOR_SET_REDIS_INTERVAL_TIME = Integer.parseInt(DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.intervalTime"));

    /**
     * 通过IAM获取租户是否是测试租户信息URL
     */
    public static final String IAM_TENANT_SIMPLE_URL = DWApplicationConfigUtils.getProperty("iamUrl") + DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.iamUserSimpleUrl");

    /**
     * 根据TOKEN通过IAM获取租户信息URL
     */
    public static final String IAM_USER_TOKEN_ANALYZE_URL = DWApplicationConfigUtils.getProperty("iamUrl") + DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.iamUserTokenAnalyzeUrl");

    /**
     * IAM 获取集成帐号信息
     */
    public static final String IAM_INTEGRATION_URL = DWApplicationConfigUtils.getProperty("iamUrl") + DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.iamIntegration");

    /**
     * 调用themeMap获取licenseKey
     */
    public static final String POST_THEMEMAP_LICENSEKEY_URL = THEMEMAP_DOMAIN_URL + DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.postThememapLicenseKeyUrl");
    /**
     * smartdata URL
     */
    public static final String SMARTDATA_URL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.smartdataUrl");

    /**
     * 执行引擎域名
     */
    public static final String EXECUTE_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.executionEngine.domain.url");

    /**
     * 调用执行引擎URL
     */
    public static final String POST_EXECUTE_URL = EXECUTE_DOMAIN_URL + DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.postExecuteUrl");

    /**
     * 排程引擎域名
     */
    public static final String SCHEDULE_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.scheduleManager.domain.url");

    /**
     * 侦测调用排程URL
     */
    public static final String POST_SCHEDULE_URL = SCHEDULE_DOMAIN_URL + DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.postScheduleUrl");

    /**
     * 数据足迹查询已发起项目的bk接口URL
     */
    public static final String DATA_FOOT_PRINT_EXISTS_BK_URL = SMARTDATA_URL + "/standard/DataFootprint/v1/task/deduplication";

    /**
     * CDME域名
     */
    public static final String CDME_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.domain.url");

    /**
     * 调用路由转发URL
     */
    public static final String POST_ROUTER_URL = CDME_DOMAIN_URL + "/standard/cdme/route/deliver";
    //public static final String POST_ROUTER_URL = "http://localhost:8084/restful/standard/cdme/route/deliver";


    /**
     * ThemeMap 获取action元数据接口URL NOTE 临时功能-1764
     */
    public static final String THEMEMAP_ACTIONMETADATA_URL = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/Action/QueryActionInfo";

    /**
     * ThemeMap 回调同步规则结果地址
     */
    public static final String THEMEMAP_SYNC_RULE_CALLBACK_URL = THEMEMAP_DOMAIN_URL + "/service/knowledgegraph/monitorRuleConfig/ReceiveMonitorRuleSyncResult";

    /**
     * 服务编排域名
     */
    public static final String SCWORKER_DOMAIN_URL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.scworker.domain.url");

    /**
     * Scwoker 获取action元数据接口URL NOTE 临时功能-1764
     */
    public static final String SCWORKER_EXISTACTIVEPROJECT_URL = SCWORKER_DOMAIN_URL + "/standard/scdispatcher/instance/isExistsRunning";

    /**
     * 服务编排发起地址
     */
    public static final String SCWORKER_PROCESS_SERVICE_URL = SCWORKER_DOMAIN_URL + "/service/scdispatcher/execution/dispatch";
    /****
     * 多环境上下文
     */
    public static final boolean MULTIPLEAPPENV = Boolean.parseBoolean(DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME,
        DWMultipleAppEnvApplicationStartingListener.CONFIG_KEY_MULTIPLE_APP_ENV));


    /**
     * iamAppToken
     */
    public static final String IAM_APP_TOKEN = DWApplicationConfigUtils.getProperty("iamApToken", "");
    /***
     * 多服务合并获取APP_TOKEN
     */
    public static final String MERGED_IAM_APP_TOKEN = DWApplicationConfigUtils.getProperty("dap.merged.apps."+DWApplicationConfigUtils.getProperty("appId")+".iamApToken", "");
    /**
     * 发起侦测mq routingKey
     */
    public static final String DETECT_MQ_ROUTINGKEY = "routingKey.schedule.executeMonitor";
    public static final String CDC_MQ_ROUTINGKEY = "routingKey.cdc.executeMonitor";
    /**
     * 发起侦测mq exchange
     */
    public static final String DETECT_MQ_EXCHANGE = "exchange_schedule";
    public static final String CDC_MQ_EXCHANGE = "exchange_cdc";
    /**
     * 发起侦测mq queue
     */
    public static final String DETECT_MQ_QUEUE = "queue_executeMonitor";
    public static final String CDC_MQ_QUEUE = "queue_cdc";
    public static final String CDC_MQ_TOPIC = "cdc";
    public static final String CDC_MQ_GROUP = "monitor";
    public static final String CDC_MQ_FACTORY = "kafkaListenerContainerFactory";
    public static final String BMSC_CDC_MQ_TOPIC = "BM_BMSC_CDC";
    public static final String MOSC_CDC_MQ_TOPIC = "BM_MOSC_CDC";
    public static final String OPSC_CDC_MQ_TOPIC = "BM_OPSC_CDC";
    public static final String PISC_CDC_MQ_TOPIC = "BM_PISC_CDC";

    public static final String PRIVATIZATION_CDC_MQ_TOPIC = "PRIVATE_0_CDC";

    public static final String CDME_MQ_GROUP = "CDME";

    /**
     * ESP 服务池 DISPATCH URL
     */
    public static final String ESP_DISPATCH_URL = MDC_DOMAIN + "/restful/standard/mdc/TenantProductInfo/Get";

    /**
     * 发起项目URL
     */
    public static final String CREATE_PROJECT_URL = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.createProjectUrl");


    /**
     * 是否开启私有化
     */
    public static final boolean PRIVATIZATION = Boolean.parseBoolean(DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.privatization", "false"));
    /**
     * 侦测分页
     */
    public static final Integer MONITOR_PAGE_SIZE = Integer.valueOf(DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.monitorPageSize"));
    /***
     * kafaka地址
     */
    public static final String KAFKA_SERVERS = DWApplicationPropertiesUtils.getProperty(APPLICATION_PROPERTIES_NAME, "cdme.spring.kafka.bootstrap-servers");
    /****
     * mqtt 是否开启
     */

   public static final boolean MQTT_OPEN=Boolean.parseBoolean(DWApplicationConfigUtils.getProperty("cdme.mqttOpen"));
}
