package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.ExceptionRetry;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.ServiceResponseUtil;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.function.Consumer;

/**
 * @description:
 * @author: dongwh
 * @date: 2021/10/19 16:28
 */
@Service("cdmeExecutionClient")
public class ExecutionClient extends AbstractExecuteClient implements IExecutionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionClient.class);

    @Override
    @ExceptionRetry(times = 3, waitTime = 300)
    public ResultDto<JSON> callExecution(Map<String, Object> executionData, boolean needSignSource) {
        LOGGER.info("侦测调用执行引擎请求入参:[{}]", JsonUtil.getJsonString(executionData));
        /** 调用执行引擎 */
        Consumer<HttpHeaders> headerAdder = needSignSource ? headers -> headers.set("monitorProcessType", "startServiceComposer") : null;
        String respContent = post(ConfigConstant.POST_EXECUTE_URL,
                executionData, DWServiceContext.getContext().getToken(), String.class, headerAdder);
        /** NOTE 调用执行引擎返回不为空且status=200就认为是正常的返回数据 */
        LOGGER.info("侦测调用执行引擎返回结果:[{}]", respContent);
        JSON respJsonObject = ServiceResponseUtil.parseExecutionRespData(respContent);
        if (respJsonObject == null) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.EE_400);
        }
        return ResultHelper.generateResult(true, "侦测调用执行引擎返回结果信息", respJsonObject);
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.EE_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR :
                return ErrorCodeEnum.EE_500;
            case BAD_GATEWAY :
                return ErrorCodeEnum.EE_502;
            case SERVICE_UNAVAILABLE :
                return ErrorCodeEnum.EE_503;
            case GATEWAY_TIMEOUT :
                return ErrorCodeEnum.EE_504;
        }
        return ErrorCodeEnum.EE_OTHER_ERR;
    }
}
