package com.digiwin.athena.cdme.service.client.request;

import com.digiwin.athena.cdme.pojo.BaseEntity;

/**
 * @description: 规则同步结果回调请求入参
 * @author: liunansheng
 * @date: 2022/2/28 9:37
 */
public class SyncRuleCallBackReq extends BaseEntity {
    public final static String SUCCESS = "success";
    public final static String FAIL = "failure";
    /**
     * mq同步规则传来的事务id
     */
    private String transactionId;
    /**
     *规则id
     */
    private String ruleId;
    /**
     *同步结果是否成功 success or failure
     */
    private String result;
    /**
     *同步失败信息
     */
    private String errorMessage;

    public SyncRuleCallBackReq(String transactionId, String ruleId, String result, String errorMessage) {
        this.transactionId = transactionId;
        this.ruleId = ruleId;
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public SyncRuleCallBackReq() {
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
