/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.pojo.dto;

import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.BaseEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class EocDto
extends BaseEntity {
    private static final int COMPANY_WEIGHT = 3;
    private static final int SITE_WEIGHT = 5;
    private static final int REGION_WEIGHT = 7;
    private String eocCompanyId;
    private String eocSiteId;
    private String eocRegionId;

    public EocDto() {
    }

    public EocDto(String eocCompanyId, String eocSiteId, String eocRegionId) {
        this.eocCompanyId = eocCompanyId;
        this.eocSiteId = eocSiteId;
        this.eocRegionId = eocRegionId;
    }

    public String getEocCompanyId() {
        return this.eocCompanyId;
    }

    public void setEocCompanyId(String eocCompanyId) {
        this.eocCompanyId = eocCompanyId;
    }

    public String getEocSiteId() {
        return this.eocSiteId;
    }

    public void setEocSiteId(String eocSiteId) {
        this.eocSiteId = eocSiteId;
    }

    public String getEocRegionId() {
        return this.eocRegionId;
    }

    public void setEocRegionId(String eocRegionId) {
        this.eocRegionId = eocRegionId;
    }

    public Map<String, Object> toUnderLineMap() {
        HashMap<String, Object> eocMap = new HashMap<String, Object>(4);
        if (StringUtil.isNotBlank(this.eocCompanyId)) {
            eocMap.put("eoc_company_id", this.eocCompanyId);
        }
        if (StringUtil.isNotBlank(this.eocSiteId)) {
            eocMap.put("eoc_site_id", this.eocSiteId);
        }
        if (StringUtil.isNotBlank(this.eocRegionId)) {
            eocMap.put("eoc_region_id", this.eocRegionId);
        }
        return eocMap;
    }

    public int calculateWeight() {
        int result = 0;
        if (StringUtil.isNotBlank(this.eocCompanyId)) {
            result += 3;
        }
        if (StringUtil.isNotBlank(this.eocSiteId)) {
            result += 5;
        }
        if (StringUtil.isNotBlank(this.eocRegionId)) {
            result += 7;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EocDto eocDto = (EocDto)o;
        return Objects.equals(this.eocCompanyId, eocDto.eocCompanyId) && Objects.equals(this.eocSiteId, eocDto.eocSiteId) && Objects.equals(this.eocRegionId, eocDto.eocRegionId);
    }

    public int hashCode() {
        return Objects.hash(this.eocCompanyId, this.eocSiteId, this.eocRegionId);
    }
}

