/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.exception.RepositoryException;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.pojo.dto.TriggerRepDto;
import com.digiwin.athena.cdme.repository.model.MonitorDupModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.service.facade.detection.data.IDupDataCacheFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorDupService;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service(value="cdmeDupDataCacheFacadeService")
public class DupDataCacheFacadeService
implements IDupDataCacheFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DupDataCacheFacadeService.class);
    private final ICacheService redisService;
    private final IMonitorDupService dupService;
    private final ISyncFacadeService disabledService;

    public DupDataCacheFacadeService(ICacheService redisService, IMonitorDupService dupService, @Qualifier(value="cdmeDISABLED") ISyncFacadeService disabledService) {
        this.redisService = redisService;
        this.dupService = dupService;
        this.disabledService = disabledService;
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public void syncProcess(MonitorRuleModel ruleModel, EocDto eocDto, JSONArray changeData, JSONArray dupdata, String redisKey, boolean isAppend) {
        JSONArray oldCache = null;
        boolean readOldCacheSuccess = false;
        try {
            boolean cacheFlag;
            JSONArray newCache = new JSONArray();
            oldCache = (JSONArray)this.redisService.get(redisKey);
            readOldCacheSuccess = true;
            if (isAppend) {
                if (CollectionUtil.isNotEmpty((Collection)oldCache)) {
                    newCache.addAll((Collection)oldCache);
                }
            } else if (CollectionUtil.isNotEmpty((Collection)dupdata)) {
                newCache.addAll((Collection)dupdata);
            }
            if (changeData != null) {
                newCache.addAll((Collection)changeData);
            }
            this.redisService.set(redisKey, newCache);
            LOGGER.info("..... \u66f4\u65b0redis\uff1aredis-value\uff1a{}  by key:{}", (Object)newCache, (Object)redisKey);
            MonitorDupModel dupModel = new MonitorDupModel(ruleModel, eocDto, newCache.toJSONString());
            MonitorDupModel monitorDup = this.dupService.getByRuleIdAndTenantIdAndProdAndEocmap(ruleModel.getRuleId(), ruleModel.getTenantId(), ruleModel.getProductName(), eocDto);
            if (monitorDup == null) {
                cacheFlag = this.dupService.save(dupModel);
            } else {
                dupModel.setId(monitorDup.getId());
                cacheFlag = this.dupService.edit(dupModel);
            }
            if (!cacheFlag) {
                throw new RepositoryException(ErrorCodeEnum.SAVE_DUP_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u66f4\u65b0Redis/DB\u6570\u636e\u5f02\u5e38", (Throwable)e);
            try {
                if (readOldCacheSuccess) {
                    this.redisService.set(redisKey, oldCache);
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
            catch (Exception e1) {
                LOGGER.error("\u540c\u6b65\u8fd8\u539fRedis/DB\u6570\u636e\u5f02\u5e38", (Throwable)e1);
            }
            this.processIfSyncFail(ruleModel, eocDto, changeData, redisKey, oldCache);
            throw new RepositoryException(ErrorCodeEnum.SAVE_DUP_FAIL);
        }
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public ResultDto<Void> cleanDeduplicateData(MonitorRuleModel ruleModel, EocDto eocDto) {
        this.dupService.deleteByRuleIdAndTenantIdAndEocmap(ruleModel.getRuleId(), ruleModel.getTenantId(), eocDto);
        StringBuilder patternKey = new StringBuilder("monitor").append(":").append(ruleModel.getTenantId()).append(":").append(ruleModel.getRuleId());
        if (StringUtil.isNotBlank(eocDto.getEocCompanyId())) {
            patternKey.append(":").append(eocDto.getEocCompanyId());
        }
        if (StringUtil.isNotBlank(eocDto.getEocSiteId())) {
            patternKey.append(":").append(eocDto.getEocSiteId());
        }
        Set<String> keys = this.redisService.keys(patternKey.append(":*").toString());
        boolean isSuccess = true;
        if (CollectionUtil.isNotEmpty(keys)) {
            isSuccess = this.redisService.delete(keys);
        }
        if (!isSuccess) {
            throw new RepositoryException(ErrorCodeEnum.CLEAN_DUP_FAIL);
        }
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    @Transactional(value="dw-transactionManager")
    public ResultDto<Void> cleanDeduplicateData(MonitorRuleModel ruleModel, TriggerRepDto triggerRepDto) {
        MonitorTriggerInsModel triggerIns = triggerRepDto.getIns();
        EocDto eocDto = new EocDto(triggerIns.getEocCompanyId(), triggerIns.getEocSiteId(), null);
        this.dupService.deleteByRuleIdAndTenantIdAndEocmap(ruleModel.getRuleId(), ruleModel.getTenantId(), eocDto);
        String redisKey = "monitor" + ":" + ruleModel.getTenantId() + ":" + ruleModel.getRuleId() + ":" + StringUtil.nullToEmpty(triggerRepDto.getIns().getEocCompanyId()) + ":" + StringUtil.nullToEmpty(triggerRepDto.getIns().getEocSiteId()) + ":" + ruleModel.getProductName();
        Set<String> keys = this.redisService.keys(redisKey);
        boolean isSuccess = true;
        if (CollectionUtil.isNotEmpty(keys)) {
            isSuccess = this.redisService.delete(keys);
        }
        if (!isSuccess) {
            throw new RepositoryException(ErrorCodeEnum.CLEAN_DUP_FAIL);
        }
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public boolean deleteCacheByKey(String cacheKey) {
        Set<String> keys = this.redisService.keys(cacheKey);
        if (CollectionUtil.isNotEmpty(keys)) {
            return this.redisService.delete(keys);
        }
        return true;
    }

    @Override
    public ResultDto<Void> saveDupData(MonitorRuleModel ruleModel, EocDto eocDto, String cacheKey, JSONArray data) {
        this.redisService.set(cacheKey, data);
        MonitorDupModel dupModel = new MonitorDupModel(ruleModel, eocDto.getEocCompanyId(), eocDto.getEocSiteId(), data.toJSONString());
        this.dupService.save(dupModel);
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public ResultDto<Void> cacheDupData(String cacheKey, JSONArray data) {
        this.redisService.set(cacheKey, data);
        return ResultHelper.generateSuccessResult(null);
    }

    @Override
    public JSONArray getDupData(String cacheKey) {
        return (JSONArray)this.redisService.get(cacheKey);
    }

    private void processIfSyncFail(MonitorRuleModel ruleModel, EocDto eocDto, JSONArray changeData, String redisKey, JSONArray oldCache) {
        LOGGER.error("\uff01\uff01\uff01 [\u540c\u6b65\u7f13\u5b58\u4e0eDB\u6570\u636e\u5931\u8d25],redisKey:[{}], changeData:{} ", (Object)redisKey, (Object)changeData);
        LOGGER.error("\uff01\uff01\uff01 [\u540c\u6b65\u7f13\u5b58\u4e0eDB\u6570\u636e\u5931\u8d25],ruleModel:[{}] eocDto:{} ", (Object)ruleModel, (Object)JsonUtil.getJsonString(eocDto));
        LOGGER.error("\uff01\uff01\uff01 [\u540c\u6b65\u7f13\u5b58\u4e0eDB\u6570\u636e\u5931\u8d25],oldCache:[{}] ", (Object)oldCache);
        LOGGER.info("\u540c\u6b65\u4fa6\u6d4b\u89c4\u5219\u5165\u53c2:ruleId:{},tenantId:{},changeType:{}", new Object[]{ruleModel.getRuleId(), ruleModel.getTenantId(), "cdmeDISABLED"});
        DWServiceContext.getContext().getRequestHeader().put("routerKey", ruleModel.getTenantId());
        SyncRuleParamDto ruleDto = new SyncRuleParamDto(ruleModel.getTenantId(), ruleModel.getRuleId(), "cdmeDISABLED", eocDto, null, null);
        ResultDto synMonitorRuleResult = this.disabledService.syncMonitorRuleHandler(ruleDto);
        if (MonitorHelper.isResultFail(synMonitorRuleResult)) {
            LOGGER.error("\u505c\u7528\u4fa6\u6d4b\u89c4\u5219:ruleId:{},tenantId:{},changeType:{}\u5931\u8d25\uff01", new Object[]{ruleModel.getRuleId(), ruleModel.getTenantId(), "cdmeDISABLED"});
            throw new BusinessException(ErrorCodeEnum.DISABLED_RULE_FAIL);
        }
    }
}

