package com.digiwin.athena.cdme;

import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.provider.IMonitorEngineApplication;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @description: 侦测引擎启动加载类
 * @author: renwm
 * @date: 2020/6/8 11:23
 */
public class CDMEApplication implements IMonitorEngineApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDMEApplication.class);

    @Override
    public Object applicationMain() {
        /** 加载esp sdk的配置,调用sdk方法进行初始化 */
        EspSdkInitialize.initConfig(ConfigConstant.ESP_DOMAIN, ConfigConstant.MDC_DOMAIN, ConfigConstant.TM_DOMAIN, ConfigConstant.EOC_DOMAIN);
        LOGGER.info("----------------------------------------------------");
        LOGGER.info("-------------CDME Application----------------");
        LOGGER.info("--------------------onStart--------------------------");
        LOGGER.info("---------------------CDME-------------------------");
        LOGGER.info("----------------{}------------------", LocalTimeUtil.getCurrentDateTime());
        LOGGER.info("-------------CDME Application----------------");
        return null;
    }
}
