package com.digiwin.athena.cdme.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.cdme.core.constant.MqttConstant;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component("cdmeActionParamsUtil")
public class ActionParamsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionParamsUtil.class);

    public static JSONArray parse(JSONArray actionParams, JSONObject msgJsonObjec ){
        List<Object> jsonArrayParam=actionParams.stream().
                filter(res->((JSONObject)res).getString(
                        MqttConstant.RULE_ACTION_PARAMS_VALUE).contains("[")).collect(Collectors.toList());
        List<Object> jsonObjectParam=actionParams.stream().
                filter(res->!((JSONObject)res).getString(
                        MqttConstant.RULE_ACTION_PARAMS_VALUE).contains("[")).collect(Collectors.toList());
//将数组格式的配置合并成一个路径获取
        JSONArray result=new JSONArray();
        if(CollectionUtils.isNotEmpty(jsonArrayParam)){
            Map<String,Object> names=new HashMap<>();
            Map<String,String> path=new HashMap<>();
            jsonArrayParam.forEach(res->{
                if(res instanceof JSONObject) {
                    String name = ((JSONObject) res).getString("name");
                    String value = ((JSONObject) res).getString(
                            MqttConstant.RULE_ACTION_PARAMS_VALUE);
                    String[] split = value.split("'");
                    if(split.length==3){
                        names.put(name, split[1]);
                        path.put("paths",split[0]+"*"+split[2]);
                    }
                }
            });
            LOGGER.info("数组配置合并后的路径为：{}",path);
            LOGGER.info("数组配置合并后的对应的key的映射关系为：{}",names);
            JSONObject data = new JSONObject();
            if(CollectionUtils.isNotEmpty(jsonObjectParam)){
                LOGGER.info("提取非数组配置项的数据:{}",jsonObjectParam);
                jsonObjectParam.forEach(res->{
                    if(res instanceof JSONObject) {
                        data.put(((JSONObject) res).getString(MqttConstant.RULE_ACTION_PARAMS_NAME), JSONPath.eval(msgJsonObjec, ((JSONObject) res).getString(MqttConstant.RULE_ACTION_PARAMS_VALUE)));
                    }
                });
            }
            //纯数组配置
            LOGGER.info("开始获取数组配置合并后的数据：{}",path);
            Object eval = JSONPath.eval(msgJsonObjec, path.get("paths"));
            LOGGER.info("获取数组配置合并后的数据：{}",eval);
            if(eval instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray) eval;
                jsonArray.forEach(res -> {
                    JSONObject jsonObject = new JSONObject();
                    if (res instanceof JSONObject) {
                        names.forEach((k, v) -> {
                            jsonObject.put(k, ((Map<Object, Object>) res).get(v));
                        });
                        jsonObject.putAll(data);
                        result.add(jsonObject);
                    } else {
                        jsonObject.putAll(((JSONObject) res));
                        result.add(jsonObject);
                    }
                });
            }
        }else{
            JSONObject data = new JSONObject();
            for (int i = 0; i < actionParams.size(); i++) {
                data.put(actionParams.getJSONObject(i).getString(MqttConstant.RULE_ACTION_PARAMS_NAME), JSONPath.eval(msgJsonObjec, actionParams.getJSONObject(i).getString(MqttConstant.RULE_ACTION_PARAMS_VALUE)));
            }
            result.add(data);
        }
        return  result;
    }

    public static void main(String[] args) {
   String actinParam2="[{\n" +
                "           \"name\": \"status\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.Data.Detail['Status']\"\n" +
                "       },{\n" +
                "           \"name\": \"exit\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.Data.exit\"\n" +
                "       }]";
        String actinParam="[{\n" +
                "           \"name\": \"status\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.Data.Detail['Status']\"\n" +
                "       },{\n" +
                "           \"name\": \"begin\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.Data.Detail['Begin']\"\n" +
                "       },{\n" +
                "           \"name\": \"userTime\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.Data.userTime\"\n" +
                "       }]";
/*        String actinParam="[{\n" +
                "           \"name\": \"app\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.APP\"\n" +
                "       },{\n" +
                "           \"name\": \"begin\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.Data.Begin\"\n" +
                "       },{\n" +
                "           \"name\": \"userTime\",\n" +
                "           \"type\": \"COLUMN\",\n" +
                "           \"value\": \"$.Data.userTime\"\n" +
                "       }]";*/
        String msgJsonObjec= "{\n" +
                "\t\"QID\": \"EEA_D63EC76A\",\n" +
                "\t\"APP\": \"BEA\",\n" +
                "\t\"STS\": 0,\n" +
                "\t\"Code\": \"000\",\n" +
                "\t\"MSG\": \"OK\",\n" +
                "\t\"Client\": \"A38C5624DE\",\n" +
                "\t\"EQID\": \"CNCO1\",\n" +
                "\t\"CMD\": \"STATUS_DETAIL\",\n" +
                "\t\"Data\": {\n" +
                "\t\t\"Begin\": \"2018-09-04 10:30:00\",\n" +
                "\t\t\"userTime\": \"2018-09-04 11:30:00\",\n" +
                "\t\t\"exit\": true," +
                "\t\t\"Detail\": [\n" +
                "\t\t\t{\n" +
                "\t\t\t\t\"Status\": \"1\",\n" +
                "\t\t\t\t\"Begin\": \"2018-09-04 10:30:30\",\n" +
                "\t\t\t\t\"End\": \"2018-09-04 10:31:45\"\n" +
                "\t\t\t},\n" +
                "\t\t\t{\n" +
                "\t\t\t\t\"Status\": \"5\",\n" +
                "\t\t\t\t\"Begin\": \"2018-09-04 10:31:45\",\n" +
                "\t\t\t\t\"End\": \"2018-09-04 10:38:19\"\n" +
                "\t\t\t}\n" +
                "\t\t]\n" +
                "\t}\n" +
                "}";

        System.out.println(ActionParamsUtil.parse(JSON.parseArray(actinParam),JSON.parseObject(msgJsonObjec)));
        System.out.println(ActionParamsUtil.parse(JSON.parseArray(actinParam2),JSON.parseObject(msgJsonObjec)));
    }

}
