/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.core.aop.RouterKey;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.ArgumentValidException;
import com.digiwin.athena.cdme.core.util.StringUtil;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="cdmeRouterKeyAspect")
@EnableAspectJAutoProxy
public class RouterKeyAspect {
    @Before(value="@annotation(routerKeyAnnotation)")
    public void validate(RouterKey routerKeyAnnotation) {
        String routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
        if (StringUtil.isEmpty(routerKey)) {
            throw new ArgumentValidException(ErrorCodeEnum.ROUTE_KEY_EMPTY);
        }
    }
}

