/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.ResponseStatusException;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IIamClient;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="cdmeIamClient")
public class IamClient
extends AbstractExecuteClient
implements IIamClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamClient.class);
    private static final String TENANT_KEY = "testTenant";
    private static final String INTEGRATION_ACCOUNT = "integration";
    private static final String PASSWORD_HASH = DWApplicationConfigUtils.getProperty((String)"cdme.IamClient.PASSWORD_HASH");

    @Override
    public boolean isTest(String tenantId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("id", tenantId);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528IAM\u67e5\u770b\u662f\u5426\u662f\u6d4b\u8bd5\u79df\u6237\u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JsonUtil.getJsonString(param));
        Map resp = this.post(ConfigConstant.IAM_TENANT_SIMPLE_URL, param, null, Map.class);
        LOGGER.info("\u4fa6\u6d4b\u8c03\u7528IAM\u67e5\u770b\u662f\u5426\u662f\u6d4b\u8bd5\u79df\u6237\u8fd4\u56de\u7ed3\u679c:[{}]", (Object)JsonUtil.getJsonString(resp));
        if (resp.containsKey(TENANT_KEY)) {
            return (Boolean)resp.get(TENANT_KEY);
        }
        return false;
    }

    @Override
    public boolean isTenantIdMatchByToken(String tenantId) {
        JSONObject userInfo = this.getUserInfoByAnalyzeToken();
        if (userInfo.isEmpty()) {
            return false;
        }
        return Objects.equals(tenantId, userInfo.getString("tenantId"));
    }

    private JSONObject getUserInfoByAnalyzeToken() {
        return this.post(ConfigConstant.IAM_USER_TOKEN_ANALYZE_URL, null, null, JSONObject.class);
    }

    @Override
    public JSONObject getLoginResponse(String secretKey) {
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put("secretKey", secretKey);
        paramMap.put("identityType", "secretKey");
        ServiceModel iamModel = new ServiceModel();
        iamModel.setInvokeURL(ConfigConstant.IAM_USERLOGINURL);
        iamModel.setParams(paramMap);
        iamModel.setRequestMethod(DWRequestMethod.POST);
        try {
            HttpResponseModel responseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)iamModel);
            return JsonUtil.getObject(responseModel.getResponseBody());
        }
        catch (Exception e) {
            throw new ResponseStatusException(ErrorCodeEnum.IAM_500, (Throwable)e);
        }
    }

    @Override
    public String getDefaultLocale() {
        ServiceModel iamModel = new ServiceModel();
        iamModel.setInvokeURL("/api/iam/v2/tenant/metadata/language");
        iamModel.setToken(DWServiceContext.getContext().getToken());
        iamModel.setRequestMethod(DWRequestMethod.GET);
        LOGGER.info("\u83b7\u53d6\u79df\u6237\u9ed8\u8ba4\u8bed\u8a00\u522b\uff0ctoken\u4e3a\uff1a{}", (Object)iamModel.getToken());
        try {
            HttpResponseModel responseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)iamModel);
            JSONObject result = JsonUtil.getObject(responseModel.getResponseBody());
            LOGGER.info("\u83b7\u53d6\u79df\u6237\u9ed8\u8ba4\u8bed\u8a00\u522b\u8fd4\u56de\u5185\u5bb9\uff1a{}", (Object)responseModel.getResponseBody());
            if (BooleanUtils.isNotTrue((Boolean)result.getBoolean("success"))) {
                throw new ResponseStatusException(ErrorCodeEnum.IAM_500);
            }
            return result.getString("data");
        }
        catch (Exception e) {
            throw new ResponseStatusException(ErrorCodeEnum.IAM_500, (Throwable)e);
        }
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.IAM_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.IAM_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.IAM_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.IAM_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.IAM_504;
            }
        }
        return ErrorCodeEnum.IAM_OTHER_ERR;
    }

    @Override
    protected boolean isNeedAuthInfo() {
        return true;
    }

    @Override
    public JSONObject getIntegration(String tenantId) {
        HashMap<String, String> requestBody = new HashMap<String, String>(4);
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", INTEGRATION_ACCOUNT);
        requestBody.put(this.getMapKey(), PASSWORD_HASH);
        LOGGER.info("\u8c03\u7528iam\u83b7\u53d6\u96c6\u6210\u5e10\u53f7\u79df\u6237\u4e3a\uff1a{}", (Object)tenantId);
        JSONObject result = this.post(ConfigConstant.IAM_INTEGRATION_URL, requestBody, null, JSONObject.class);
        LOGGER.info("\u8c03\u7528iam\u83b7\u53d6\u96c6\u6210\u5e10\u53f7\u4fe1\u606f\u4e3a\uff1a{}", (Object)JsonUtil.getJsonString(result));
        return result;
    }

    @Override
    public JSONObject getTenantId(String tenantSid) {
        HashMap<String, String> requestBody = new HashMap<String, String>(4);
        requestBody.put("tenantSid", tenantSid);
        requestBody.put("userId", INTEGRATION_ACCOUNT);
        requestBody.put(this.getMapKey(), PASSWORD_HASH);
        LOGGER.info("\u8c03\u7528iam\u83b7\u53d6\u79df\u6237ID\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)tenantSid);
        Consumer<HttpHeaders> headerAdder = headers -> headers.set("digi-middleware-auth-app", ConfigConstant.MULTIPLEAPPENV ? ConfigConstant.MERGED_IAM_APP_TOKEN : ConfigConstant.IAM_APP_TOKEN);
        JSONObject result = this.postWithoutRouterkey(ConfigConstant.IAM_INTEGRATION_URL, requestBody, null, JSONObject.class, headerAdder);
        LOGGER.info("\u8c03\u7528iam\u83b7\u53d6\u5e10\u53f7\u4fe1\u606f\u4e3a\uff1a{}", (Object)JsonUtil.getJsonString(result));
        return result;
    }

    private String getMapKey() {
        return "passwordHash";
    }
}

