/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.request.RouterRequest;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IRouterClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service(value="cdmeRouterClient")
public class RouterClient
extends AbstractExecuteClient
implements IRouterClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterClient.class);

    @Override
    public ResultDto deliver(String queueMsg, String tenantId) {
        RouterRequest routerRequest = new RouterRequest();
        routerRequest.setQueueMsg(queueMsg);
        routerRequest.setTenantId(tenantId);
        String url = ConfigConstant.POST_ROUTER_URL;
        try {
            JSONObject routerResult = this.execute(url, (Object)routerRequest, DWServiceContext.getContext().getToken(), JSONObject.class, HttpMethod.POST, new Object[0]);
            return ResultHelper.generateSuccessResult(null);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528CDME\u8def\u7531\u670d\u52a1\u5f02\u5e38\uff1a{}", (Throwable)e);
            return ResultHelper.generateFailResult(ErrorCodeEnum.ROUTER_DELIVER_ERR, new Object[0]);
        }
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.CDME_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR: {
                return ErrorCodeEnum.CDME_500;
            }
            case BAD_GATEWAY: {
                return ErrorCodeEnum.CDME_502;
            }
            case SERVICE_UNAVAILABLE: {
                return ErrorCodeEnum.CDME_503;
            }
            case GATEWAY_TIMEOUT: {
                return ErrorCodeEnum.CDME_504;
            }
        }
        return ErrorCodeEnum.CDME_OTHER_ERR;
    }
}

