/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.service.srp.db;

import com.digiwin.athena.cdme.core.base.IRepositoryService;
import com.digiwin.athena.cdme.repository.IBaseMapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepositorService<M extends IBaseMapper<T>, T>
implements IRepositoryService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRepositorService.class);
    protected M mapper;

    public AbstractRepositorService(M mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean save(T entity) {
        int result = this.mapper.insert(entity);
        if (result < 1) {
            LOGGER.error("\u63d2\u5165\u8bb0\u5f55\u5931\u8d25\uff1a[{}]", entity);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteById(Serializable id) {
        int result = this.mapper.deleteById(id);
        if (result < 1) {
            LOGGER.error("\u6839\u636e ID \u5220\u9664\u5931\u8d25\uff1a[{}]", (Object)id);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteBatchIds(Collection<? extends Serializable> idList) {
        int result = this.mapper.deleteBatchIds(idList);
        if (result < idList.size()) {
            LOGGER.error("\u6839\u636eID \u6279\u91cf\u5220\u9664\u5931\u8d25\uff1a[{}]", idList);
            return false;
        }
        return true;
    }

    @Override
    public boolean edit(T entity) {
        int result = this.mapper.updateById(entity);
        if (result < 1) {
            LOGGER.error("\u6839\u636e ID \u4fee\u6539\u5931\u8d25\uff1a[{}]", entity);
            return false;
        }
        return true;
    }

    @Override
    public T getById(Serializable id) {
        LOGGER.info("\u6839\u636e ID \u67e5\u8be2\uff1a[{}]", (Object)id);
        return (T)this.mapper.selectById(id);
    }

    @Override
    public List<T> listByBatchIds(Collection<? extends Serializable> idList) {
        LOGGER.info("\u6839\u636eID \u6279\u91cf\u67e5\u8be2\uff1a[{}]", idList);
        return this.mapper.selectBatchIds(idList);
    }
}

