package com.digiwin.athena.cdme.core.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * rabbitmq 属性配置信息，后续删除xml配置时需放开注释
 *
 * @author zhangzhi@digiwin.com
 * @date 2021/6/15
 */
@Configuration
public class CdmeRabbitMQProp {

    @Value("${spring.rabbitmq.listener.simple.concurrency:5}")
    private int simpleConcurrency;

    @Value("${spring.rabbitmq.listener.simple.max-concurrency:10}")
    private int simpleMaxConcurrency;

    @Value("${spring.rabbitmq.listener.simple.prefetch:1}")
    private int simplePrefetch;

    @Value("${spring.rabbitmq.listener.simple.retry.initial-interval:1000}")
    private int simpleInitialInterval;

    @Value("${spring.rabbitmq.listener.simple.retry.max-interval:10000}")
    private int simpleMaxInterval;

    @Value("${spring.rabbitmq.listener.simple.retry.multiplier:2}")
    private int simpleMultiplier;
    @Value("${spring.rabbitmq.host}")
    private String host;

    @Value("${spring.rabbitmq.port}")
    private int port;

    @Value("${spring.rabbitmq.username}")
    private String username;

    @Value("${spring.rabbitmq.password}")
    private String password;

    @Value("${spring.rabbitmq.virtual-host}")
    private String virtualHost;


    public String getVirtualHost() {
        return virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getSimpleConcurrency() {
        return simpleConcurrency;
    }

    public int getSimpleMaxConcurrency() {
        return simpleMaxConcurrency;
    }

    public int getSimplePrefetch() {
        return simplePrefetch;
    }

    public int getSimpleInitialInterval() {
        return simpleInitialInterval;
    }

    public int getSimpleMaxInterval() {
        return simpleMaxInterval;
    }

    public int getSimpleMultiplier() {
        return simpleMultiplier;
    }
}
