package com.digiwin.athena.cdme.mq.consumer.monitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.mq.producer.MessageProducer;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorRuleCdcService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

/**
 * @author yangxiao
 * @description: 监听BM_MOSC_CDC Topic的侦测消息
 * @date 2023/10/10 11:10
 */
@Component("cdmeMonitorTransferMoscCdcListener")
public class MonitorTransferMoscCdcListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTransferMoscCdcListener.class);

    private final IMonitorFacadeService monitorFacadeService;

    public MonitorTransferMoscCdcListener(IMonitorFacadeService monitorFacadeService) {
        this.monitorFacadeService = monitorFacadeService;
    }

    @KafkaListener(topics = {ConfigConstant.MOSC_CDC_MQ_TOPIC}, groupId = ConfigConstant.CDME_MQ_GROUP, containerFactory = ConfigConstant.CDC_MQ_FACTORY, errorHandler = "cdmeConsumerAwareErrorHandler")
    public void consumeMonitorMsg(ConsumerRecord<?, ?> record, Acknowledgment ack) {
        LOGGER.info("侦测引擎接收CDC的转发消息来自MOSC Topic为:[{}]", record.value());
        JSONObject recordJsonObject = JSON.parseObject(String.valueOf(record.value()));
        ResultDto resultDto = monitorFacadeService.executeDeliver(recordJsonObject);
        if(resultDto.getSuccess()){
            ack.acknowledge();
        }
    }
}
