/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.core.aop;

import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.aop.ExceptionRetry;
import com.digiwin.athena.cdme.core.exception.ResponseStatusException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpServerErrorException;

@Aspect
@Component(value="cdmeExceptionRetryAspect")
@EnableAspectJAutoProxy
public class ExceptionRetryAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionRetryAspect.class);

    @Pointcut(value="@annotation(com.digiwin.athena.cdme.core.aop.ExceptionRetry)")
    public void retryPointCut() {
    }

    @Around(value="retryPointCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ExceptionRetry retry = method.getAnnotation(ExceptionRetry.class);
        String name = method.getName();
        Object[] args = joinPoint.getArgs();
        String uuid = UUID.randomUUID().toString();
        LOGGER.info("\u6267\u884c\u91cd\u8bd5\u5207\u9762{}, \u65b9\u6cd5\u540d\u79f0{}, \u65b9\u6cd5\u53c2\u6570{}", new Object[]{uuid, name, JsonUtil.getJsonString(args)});
        int times = retry.times();
        long waitTime = retry.waitTime();
        if (times <= 0) {
            times = 1;
        }
        while (times >= 0) {
            try {
                return joinPoint.proceed();
            }
            catch (Exception e) {
                if (e.getClass() != ResponseStatusException.class) {
                    throw e;
                }
                HttpServerErrorException e1 = (HttpServerErrorException)e.getCause();
                if (e1.getResponseBodyAsString().indexOf("502 Bad Gateway") == -1) {
                    throw e;
                }
                if (times <= 0) {
                    LOGGER.warn("\u6267\u884c\u91cd\u8bd5\u5207\u9762{}\u5931\u8d25", (Object)uuid);
                    throw e;
                }
                if (waitTime > 0L) {
                    Thread.sleep(waitTime);
                }
                LOGGER.warn("\u6267\u884c\u91cd\u8bd5\u5207\u9762{}, \u8fd8\u6709{}\u6b21\u91cd\u8bd5\u673a\u4f1a, \u5f02\u5e38\u7c7b\u578b{}, \u5f02\u5e38\u4fe1\u606f{}, \u6808\u4fe1\u606f{}", new Object[]{uuid, times, e.getClass().getName(), e.getMessage(), e.getStackTrace()});
                --times;
            }
        }
        return false;
    }
}

