package com.digiwin.athena.cdme.core.util;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.cdme.core.constant.MqttConstant;

/**
 * @author yang.xiao
 * @version V1.0
 * @Description
 * @date 2024/7/8 14:53
 * @Copyright 鼎捷软件股份有限公司
 */
public final class MqttUtil {
    /***
     * "$share/" + appId + "/" + mqArea + "/" + "313009111757376" + "/+/+/+/" + "EqInfo/GetStatus"
     * @param tenantSid
     * @param tableName
     * @return
     */
    public static String getDeviceCloudTopic(String tenantSid, String tableName,String zone){
        String appId = DWApplicationConfigUtils.getProperty("appId");
        String mqArea = zone;
        String topicPrefix = "$share/" + appId + "/" + mqArea + "/";
        String topicMid = "/+/+/+/";
        String topic = topicPrefix + tenantSid + topicMid + tableName;
        return topic;
    }
    public static String getTopicByDbname(String tenantSid, String tableName,String dbName,String zone){
        String topic="";
        switch (dbName){
            case MqttConstant.DEVICE_CLOUD:
                topic=getDeviceCloudTopic(tenantSid,tableName,zone);
                break;
            default:
                topic=getDeviceCloudTopic(tenantSid,tableName,zone);
                break;
        }
        return topic;
    }
}