package com.digiwin.athena.cdme.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.constant.ConfigConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.DWResponseUtil;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.ServiceResponseUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.AbstractExecuteClient;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.request.ExistActiveProjectReq;
import com.digiwin.athena.cdme.service.client.request.ProcessServiceComposerReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

/**
 * @description: 服务编排客户端实现
 * @author: liunansheng
 * @date: 2021/10/22 14:09
 */
@Component("cdmeScWokerClient")
public class ScWokerClient extends AbstractExecuteClient implements IScwokerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScWokerClient.class);

    @Override
    public boolean existActiveProject(String serviceComposerId, String tenantId, EocDto eocMap) {
        ExistActiveProjectReq req = new ExistActiveProjectReq(serviceComposerId, tenantId, eocMap);
        LOGGER.info("侦测调用服务编排查询是否有进行中项目请求参数:[{}]", req);
        JSONObject responseObj = post(ConfigConstant.SCWORKER_EXISTACTIVEPROJECT_URL,
                req, DWServiceContext.getContext().getToken(), JSONObject.class);
        LOGGER.info("侦测调用服务编排查询是否有进行中项目返回结果:[{}]", responseObj);
        ResultDto<Boolean> rs = DWResponseUtil.convertResponse(responseObj, Boolean.class);
        if (MonitorHelper.isResultFail(rs)) {
            throw new BusinessException(ErrorCodeEnum.SCWOKER_400);
        }
        return rs.getData();
    }

    @Override
    public ResultDto<JSON> processService(String serviceComposerId, String tenantId, EocDto eocDto, JSONArray monitorData) {
        ProcessServiceComposerReq req = new ProcessServiceComposerReq(serviceComposerId, tenantId, eocDto, monitorData);
        LOGGER.info("侦测调用服务编排请求入参:[{}]", JsonUtil.getJsonString(req));
        /** 调用服务编排 */
        String respContent = post(ConfigConstant.SCWORKER_PROCESS_SERVICE_URL, req, DWServiceContext.getContext().getToken(), String.class);
        /** NOTE 调用服务编排返回不为空且status=200就认为是正常的返回数据 */
        LOGGER.info("侦测调用服务编排返回结果:[{}]", respContent);
        JSON respJsonObject = ServiceResponseUtil.parseExecutionRespData(respContent);
        if (respJsonObject == null) {
            return ResultHelper.generateFailResult(ErrorCodeEnum.SCWOKER_400);
        }
        return ResultHelper.generateSuccessResult(respJsonObject);
    }

    @Override
    protected HttpHeaders initHeader(String token) {
        HttpHeaders headers = super.initHeader(token);
        headers.add("invokerId", "MonitorEngine");
        return headers;
    }

    @Override
    protected ErrorCodeEnum getErrorCodeByHttpStatus(String url, HttpStatus httpStatus) {
        if (null == httpStatus) {
            return ErrorCodeEnum.SCWOKER_OTHER_ERR;
        }
        switch (httpStatus) {
            case INTERNAL_SERVER_ERROR :
                return ErrorCodeEnum.SCWOKER_500;
            case BAD_GATEWAY :
                return ErrorCodeEnum.SCWOKER_502;
            case SERVICE_UNAVAILABLE :
                return ErrorCodeEnum.SCWOKER_503;
            case GATEWAY_TIMEOUT :
                return ErrorCodeEnum.SCWOKER_504;
        }
        return ErrorCodeEnum.SCWOKER_OTHER_ERR;
    }
}
