package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IEspClient;
import com.digiwin.athena.cdme.service.client.request.EspSdkReq;
import com.digiwin.athena.cdme.service.facade.detection.data.IProcessDetectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description: 执行scheme定义中的sql到地端获取数据
 * @author: dongwh
 * @date: 2022/7/15 16:27
 */
@Service(FieldValConstant.CATEGORY_SQL_SCRIPT)
public class SqlScriptDetectionService implements IProcessDetectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlScriptDetectionService.class);

    private final IEspClient espClient;

    public SqlScriptDetectionService(IEspClient espClient) {
        this.espClient = espClient;
    }

    @Override
    public ResultDto<JSONArray> processDetection(Map<String, JSONObject> allParam, DetectionRequestDto requestDto) {
        EspSdkReq sqlScriptParam = buildSqlScriptParam(allParam, requestDto.getRuleModel(), requestDto.getEoc());
        LOGGER.info("侦测调用ESP开始*************");
        /** 调用ESP接口,接收返回消息 */
        ResultDto<JSONArray> scanResult = espClient.getChangeObjects(sqlScriptParam);
        LOGGER.info("侦测调用ESP结束*************");
        return scanResult;
    }

    private EspSdkReq buildSqlScriptParam(Map<String, JSONObject> allParam, MonitorRuleModel ruleInfo, EocDto eocDto) {
        JSONArray dynamicCondition = MonitorHelper.transformToDynamicCondition(allParam);
        JSONObject monitorRule = JsonUtil.getObject(ruleInfo.getMonitorRule());
        return MonitorHelper.buildDataChangeSqlGetRequest(ruleInfo.getRuleId(), ruleInfo.getTenantId(), ruleInfo.getProductName(),
                dynamicCondition, monitorRule, eocDto);
    }
}
