package com.digiwin.athena.cdme.service.facade.rulesync;

import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description: 规则同步代理类
 * @author: liunansheng
 * @date: 2022/2/22 10:38
 */
@Service("cdmeRuleSyncFacadeProxy")
public class RuleSyncFacadeProxy {

    private final Map<String, ISyncFacadeService> synServiceBeanMap;

    public RuleSyncFacadeProxy(Map<String, ISyncFacadeService> synServiceBeanMap) {
        this.synServiceBeanMap = synServiceBeanMap;
    }

    /**
     * 同步规则信息
     *
     * @param ruleDto
     * @return
     */
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        ISyncFacadeService monitorRuleService = synServiceBeanMap.get("cdme"+ruleDto.getChangeType());
        if (monitorRuleService == null) {
            throw new BusinessException(ErrorCodeEnum.RULE_SYNC_TYPE_ERR);
        }
        return monitorRuleService.syncMonitorRuleHandler(ruleDto);
    }
}
