/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cdme.pojo.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.cdme.JsonUtil;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessPageDto {
    @JSONField(serialize=false)
    private List<JSONArray> successChangeObjects = new ArrayList<JSONArray>();
    private List<ResultDto> errorResponse = new ArrayList<ResultDto>();
    private List<JSON> response = new ArrayList<JSON>();
    private int pageNum;
    private int pageSize;

    public ProcessPageDto(int pageNum, int pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public void addSuccessChangeObjects(JSONArray objects) {
        if (null == objects) {
            this.successChangeObjects.add(new JSONArray());
            return;
        }
        this.successChangeObjects.add(objects);
    }

    public void addErrorResponse(ResultDto failRs) {
        this.response.add(JsonUtil.getJson(failRs));
        this.errorResponse.add(failRs);
    }

    public void addSuccessResponse(JSON json) {
        this.response.add(json);
    }

    public boolean allSuccess() {
        return CollectionUtil.isEmpty(this.errorResponse);
    }

    public boolean partFail() {
        return this.errorResponse.size() > 0 && this.errorResponse.size() != this.pageNum;
    }

    public boolean allFail() {
        return this.errorResponse.size() == this.pageNum;
    }

    public JSONArray genSuccessChangeObjects() {
        if (this.errorResponse.size() == this.pageNum) {
            return new JSONArray();
        }
        return new JSONArray(this.successChangeObjects.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public List<JSONArray> getSuccessChangeObjects() {
        return this.successChangeObjects;
    }

    public List<ResultDto> getErrorResponse() {
        return this.errorResponse;
    }

    public List<JSON> getResponse() {
        return this.response;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String toString() {
        return JsonUtil.getJsonString(this);
    }
}

