package com.digiwin.athena.cdme.core.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.athena.cdme.core.util.LocalTimeUtil;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

/**
 * @author dongwh
 * @date 2022/3/4 10:16
 */
@Configuration
@MapperScan(value = "com.digiwin.athena.cdme.repository",sqlSessionTemplateRef = "cdmeSqlSessionTemplate")
public class CdmeMyBatisPlusConfig {

    @Bean("cdmeDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.cdme")
    public DruidDataSource cdmeDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean("cdmeCreateSqlSession")
    public SqlSessionFactory cdmeCreateSqlSession(@Qualifier("cdmeDataSource") DataSource source) throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(source);
        factoryBean.setConfiguration(cdmeMybatisConfiguration());
        factoryBean.setGlobalConfig(globalConfig());
        factoryBean.setPlugins(cdmeMybatisPlusInterceptor());
        return factoryBean.getObject();
    }

    @Bean("cdmeMybatisConfiguration")
    public MybatisConfiguration cdmeMybatisConfiguration() {
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setMapUnderscoreToCamelCase(true);
        return configuration;
    }

    private GlobalConfig globalConfig() {
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setDbConfig(dbConfig());
        return globalConfig;
    }

    private GlobalConfig.DbConfig dbConfig() {
        return new GlobalConfig.DbConfig();
    }

    @Bean("cdmeMybatisPlusInterceptor")
    public MybatisPlusInterceptor cdmeMybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
        dynamicTableNameInnerInterceptor.setTableNameHandler((sql, tableName) -> {
            if ("sd_monitor_record".equalsIgnoreCase(tableName)) {
                return tableName + LocalTimeUtil.getCurrentDateTime().substring(0, 7).replace('-', '_');
            }
            return tableName;
        });
        interceptor.addInnerInterceptor(dynamicTableNameInnerInterceptor);
        return interceptor;
    }
    @Bean(name = "cdmeTransactionManager")
    @Primary
    public DataSourceTransactionManager cdme1TransactionManager(@Qualifier("cdmeDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
    @Bean(name = "cdmeSqlSessionTemplate")
    @Primary
    public SqlSessionTemplate cdmeSqlSessionTemplate(@Qualifier("cdmeCreateSqlSession") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}