package com.digiwin.athena.cdme.pojo.dto;

import com.digiwin.athena.cdme.pojo.BaseEntity;

import java.util.List;

/**
 * @author zhangww
 * @description: eoc调整消息内容
 * @date 2021/8/4 11:14
 */
public class CrossLevelDto extends BaseEntity {

    private String transactionId;

    private String tenantId;

    private String ruleId;

    private EocDto eocMap;

    private List<EocDto> newEocList;

    public CrossLevelDto() {
    }

    public CrossLevelDto(String tenantId, String ruleId, EocDto eocMap, List<EocDto> newEocList) {
        this(tenantId, ruleId, eocMap, newEocList, null);
    }

    public CrossLevelDto(String tenantId, String ruleId, EocDto eocMap, List<EocDto> newEocList, String transactionId) {
        this.tenantId = tenantId;
        this.ruleId = ruleId;
        this.eocMap = eocMap;
        this.newEocList = newEocList;
        this.transactionId = transactionId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public EocDto getEocMap() {
        return eocMap;
    }

    public void setEocMap(EocDto eocMap) {
        this.eocMap = eocMap;
    }

    public List<EocDto> getNewEocList() {
        return newEocList;
    }

    public void setNewEocList(List<EocDto> newEocList) {
        this.newEocList = newEocList;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

}
