package com.digiwin.athena.cdme.pojo.dto;

import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;

/**
 * @description: 调用ThemeMap接口获取定义的侦测规则
 * @author: dongwh
 * @date: 2021/1/4 11:21
 */
public class MonitorRuleDto {

    /**
     * 侦测规则信息
     */
    private MonitorRuleModel ruleModel;

    /**
     * 侦测规则触发排程信息
     */
    private MonitorTriggerModel triggerModel;

    /**
     * 规则扩展配置
     */
    private RuleExtensionDto extensionDto;

    public MonitorRuleDto() {

    }

    public MonitorRuleDto(MonitorRuleModel ruleModel, MonitorTriggerModel triggerModel) {
        this.ruleModel = ruleModel;
        this.triggerModel = triggerModel;
    }

    public MonitorRuleDto(MonitorRuleModel ruleModel, MonitorTriggerModel triggerModel, RuleExtensionDto extensionDto) {
        this.ruleModel = ruleModel;
        this.triggerModel = triggerModel;
        this.extensionDto = extensionDto;
    }

    public MonitorRuleModel getRuleModel() {
        return ruleModel;
    }

    public void setRuleModel(MonitorRuleModel ruleModel) {
        this.ruleModel = ruleModel;
    }

    public MonitorTriggerModel getTriggerModel() {
        return triggerModel;
    }

    public void setTriggerModel(MonitorTriggerModel triggerModel) {
        this.triggerModel = triggerModel;
    }

    public RuleExtensionDto getExtensionDto() {
        return extensionDto;
    }

    public void setExtensionDto(RuleExtensionDto extensionDto) {
        this.extensionDto = extensionDto;
    }

    public String getRuleId() {
        return null == this.ruleModel ? null : this.ruleModel.getRuleId();
    }

    public String getTenantId() {
        return null == this.ruleModel ? null : this.ruleModel.getTenantId();
    }

    public EocDto getRuleEoc() {
        return null == this.ruleModel ? null : new EocDto(this.ruleModel.getEocCompanyId(), this.ruleModel.getEocSiteId(), this.ruleModel.getEocRegionId());
    }

    public String getTriggerId() {
        return null == this.triggerModel ? null : this.triggerModel.getId();
    }
}
