package com.digiwin.athena.cdme.provider.converter;

import com.digiwin.athena.cdme.core.enums.MonitorOpsActionStatusEnum;
import com.digiwin.athena.cdme.core.enums.MonitorOpsEnum;
import com.digiwin.athena.cdme.core.enums.MonitorOpsMonitorStatusEnum;
import com.digiwin.athena.cdme.pojo.dto.RuleOpsDto;
import com.digiwin.athena.cdme.pojo.vo.MonitorOpsDetailVo;
import com.digiwin.athena.cdme.pojo.vo.MonitorOpsSummaryVo;
import com.digiwin.athena.cdme.repository.model.MonitorRecordModel;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/3/15 16:51
 */
public class MonitorOpsVoConverter {

    public static MonitorOpsDetailVo convertOpsDetailVoByDto(RuleOpsDto dto) {
        if (dto == null) {
            return null;
        }
        MonitorOpsDetailVo vo = new MonitorOpsDetailVo();
        MonitorRuleModel rule = dto.getRuleModel();
        MonitorTriggerModel trigger = dto.getTriggerModel();
        MonitorTriggerInsModel ins = dto.getIns();
        MonitorRecordModel record = dto.getRecordModel();
        vo.setRuleId(rule.getRuleId());
        vo.setIsEnable(MonitorOpsEnum.getEnumByType(rule.getIsEnable()));
        vo.setCategory(rule.getCategory());
        vo.setCreateTime(rule.getCreateTime());
        vo.setUpdateTime(rule.getUpdateTime());
        vo.setTenantId(rule.getTenantId());
        vo.setEocCompanyId(rule.getEocCompanyId());
        vo.setEocSiteId(rule.getEocSiteId());
        vo.setProductName(rule.getProductName());
        vo.setTriggerId(rule.getTriggerId());
        if (null != trigger) {
            vo.setTriggerParam(trigger.getTriggerParam());
            vo.setLastMonitorTime(trigger.getLastMonitorTime());
        }
        if (null != ins) {
            vo.setEocCompanyId(ins.getEocCompanyId());
            vo.setEocSiteId(ins.getEocSiteId());
            if (null != ins.getLastMonitorTime()) {
                vo.setLastMonitorTime(ins.getLastMonitorTime());
            }
        }
        if (null != record) {
            vo.setMonitorStatus(MonitorOpsMonitorStatusEnum.getEnumByType(record.getMonitorStatus()));
            vo.setActionStatus(MonitorOpsActionStatusEnum.getEnumByType(record.getActionStatus()));
            vo.setActionResult(record.getActionResult());
        }
        return vo;
    }

    public static MonitorOpsSummaryVo convertModelToOpsSummaryVo(MonitorRuleModel rule) {
        MonitorOpsSummaryVo vo = new MonitorOpsSummaryVo();
        vo.setIsEnable(MonitorOpsEnum.getEnumByType(rule.getIsEnable()));
        vo.setCreateTime(rule.getCreateTime());
        vo.setEocCompanyId(rule.getEocCompanyId());
        vo.setEocSiteId(rule.getEocSiteId());
        vo.setRuleId(rule.getRuleId());
        vo.setTriggerId(rule.getTriggerId());
        return vo;
    }
}
