package com.digiwin.athena.cdme.service.facade.detection.data.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.DetectionRequestDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleModel;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import com.digiwin.athena.cdme.service.facade.detection.data.IProcessDetectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description: api类型侦测
 * @author: dongwh
 * @date: 2020/9/27 11:31
 */
@Service(FieldValConstant.CATEGORY_API)
public class ApiDetectionService implements IProcessDetectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDetectionService.class);

    private final IExecutionClient executionClient;

    public ApiDetectionService(IExecutionClient executionClient) {
        this.executionClient = executionClient;
    }

    @Override
    public ResultDto<JSONArray> processDetection(Map<String, JSONObject> allParam, DetectionRequestDto requestDto) {
        MonitorRuleModel ruleModel = requestDto.getRuleModel();
        /** 调用执行引擎入参*/
        Map<String, Object> monitorActionParam = MonitorHelper.buildExecutionParam(ruleModel, requestDto.getEoc(), null, allParam, FieldValConstant.EXECUTE_TYPE_MONITOR_ACTION);
        LOGGER.info("API类型侦测发起Monitor Action开始*************");
        /** 调用执行引擎调用api获取地端数据*/
        ResultDto<JSON> monitorActionResult = executionClient.callExecution(monitorActionParam, false);
        LOGGER.info("API类型侦测发起Monitor Action结束*************");
        if (MonitorHelper.isResultFail(monitorActionResult)) {
            return ResultHelper.generateFailResult(monitorActionResult.getCode(), monitorActionResult.getMessage());
        }
        /** 数据型侦测数据节点取 */
        if (null != monitorActionResult.getData() && MonitorHelper.isPollingIds(ruleModel.getMonitorRule())) {
            JSONObject data = (JSONObject)monitorActionResult.getData();
            return ResultHelper.generateSuccessResult(data.getJSONArray(FieldConstant.ESP_CHANGE_OBJECTS));
        } else {
            JSONArray tmp = null;
            if (monitorActionResult.getData() instanceof JSONArray) {
                tmp = (JSONArray) monitorActionResult.getData();
            } else {
                tmp = new JSONArray();
                tmp.add(monitorActionResult.getData());
            }
            return  ResultHelper.generateSuccessResult(tmp);
        }
    }
}
