package com.digiwin.athena.cdme.service.facade.detection.impl;

import com.digiwin.athena.cdme.core.config.CdmeApplicationProp;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.util.CollectionUtil;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.bo.EocTimeRangeBO;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerInsModel;
import com.digiwin.athena.cdme.repository.model.MonitorTriggerModel;
import com.digiwin.athena.cdme.service.facade.detection.IDetectionTimeRangeService;
import com.digiwin.athena.cdme.service.srp.db.IMonitorTriggerInsService;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/11/3 13:24
 */
@Service("cdmeDetectionTimeRangeService")
public class DetectionTimeRangeService implements IDetectionTimeRangeService {

    private final IMonitorTriggerInsService insService;

    private final CdmeApplicationProp applicationProp;

    public DetectionTimeRangeService(IMonitorTriggerInsService insService, CdmeApplicationProp applicationProp) {
        this.insService = insService;
        this.applicationProp = applicationProp;
    }

    @Override
    public List<EocTimeRangeBO> getTimeRange(MonitorTriggerModel triggerModel, boolean needOffset, List<EocDto> eocList) {
        List<MonitorTriggerInsModel> insModels = insService.listByTriggerId(triggerModel.getId());
        List<EocTimeRangeBO> timeRangeBOS = new ArrayList<>();
        for (EocDto eoc : eocList) {
            MonitorTriggerInsModel ins = findIns(eoc, insModels);
            if (null == ins) {
                ins = new MonitorTriggerInsModel(triggerModel.getId(), eoc.getEocCompanyId(), eoc.getEocSiteId());
            }
            LocalDateTime startTime;
            LocalDateTime configStartTime = triggerModel.getLastMonitorTime();
            LocalDateTime lastMonitorTime = ins.getLastMonitorTime();
            //取配置的起始时间 和 上次侦测时间两者最晚的一个时间作为开始时间，都没有，当前时间作为开始时间
            if (null == lastMonitorTime && null == configStartTime) {
                startTime = triggerModel.getCreateTime();
            } else if (null == lastMonitorTime && null != configStartTime) {
                startTime = configStartTime;
            } else if (null != lastMonitorTime && null == configStartTime) {
                startTime = lastMonitorTime;
            } else {
                startTime = lastMonitorTime.isAfter(configStartTime) ? lastMonitorTime : configStartTime;
            }
            //需要向前偏移一段时间，防止漏数据
            if (needOffset && applicationProp.getMonitorOffsetTime() != null) {
                startTime = startTime.minus(applicationProp.getMonitorOffsetTime(), ChronoUnit.MILLIS);
            }
            EocTimeRangeBO timeRangeBO = new EocTimeRangeBO(eoc, startTime, LocalDateTime.now(), ins);
            timeRangeBOS.add(timeRangeBO);
        }
        return timeRangeBOS;
    }

    @Override
    public ResultDto<Void> moveTimeRange(EocTimeRangeBO timeRangeBO) {
        MonitorTriggerInsModel ins = timeRangeBO.getIns();
        ins.setLastMonitorTime(timeRangeBO.getEndTime());
        boolean success = insService.saveOrEdit(ins);
        if (success) {
            return ResultHelper.generateSuccessResult(null);
        }
        return ResultHelper.generateFailResult(ErrorCodeEnum.SAVE_INS_FAIL);
    }

    private MonitorTriggerInsModel findIns(EocDto eoc, List<MonitorTriggerInsModel> insModels) {
        if (CollectionUtil.isEmpty(insModels)) {
            return null;
        }
        for (MonitorTriggerInsModel ins : insModels) {
            EocDto insEoc = new EocDto(ins.getEocCompanyId(), ins.getEocSiteId(), null);
            if (eoc.equals(insEoc)) {
                return ins;
            }
        }
        return null;
    }
}
