package com.digiwin.athena.cdme.service.facade.detection.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.cdme.constant.FieldConstant;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.repository.model.MonitorRuleCdcModel;
import com.digiwin.athena.cdme.service.client.IExecutionClient;
import com.digiwin.athena.cdme.service.client.IRouterClient;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.ITaskEngineClient;
import com.digiwin.athena.cdme.service.client.impl.IamClient;
import com.digiwin.athena.cdme.service.facade.auth.IContextFacadeService;
import com.digiwin.athena.cdme.service.facade.detection.IMonitorFacadeService;
import com.digiwin.athena.cdme.service.srp.cache.ICacheService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/10/31 16:00
 */
@Service("cdmeMonitorFacadeService")
public class MonitorFacadeService implements IMonitorFacadeService {

    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorFacadeService.class);

    private final IamClient iamClient;

    private final IExecutionClient executionClient;

    private final IScwokerClient scwokerClient;

    private final ITaskEngineClient taskEngineClient;

    private final ICacheService redisService;

    private final IRouterClient routerClient;

    private final IContextFacadeService contextService;

    public MonitorFacadeService(IamClient iamClient, IExecutionClient executionClient, IScwokerClient scwokerClient, ITaskEngineClient taskEngineClient
            , ICacheService redisService, IRouterClient routerClient, IContextFacadeService contextService) {
        this.iamClient = iamClient;
        this.executionClient = executionClient;
        this.scwokerClient = scwokerClient;
        this.taskEngineClient = taskEngineClient;
        this.redisService = redisService;
        this.routerClient = routerClient;
        this.contextService = contextService;
    }

    @Override
    public ResultDto executeCdc(MonitorRuleCdcModel monitorRuleCdcModel, EocDto eocDto, JSONArray monitorData) {
        if (FieldConstant.SERVICECOMPOSER_ACTION.equalsIgnoreCase(monitorRuleCdcModel.getActionType())) {
            initLocale();
            return scwokerClient.processService(monitorRuleCdcModel.getActionId(), monitorRuleCdcModel.getTenantId(), eocDto, monitorData);
        } else if (FieldConstant.TASK_ACTION.equalsIgnoreCase(monitorRuleCdcModel.getActionType())) {
            initLocale();
            return taskEngineClient.createProject(monitorRuleCdcModel.getActionId(), eocDto, monitorData);
        } else {
            Map<String, Object> param = MonitorHelper.buildCdcExecutionParam(monitorRuleCdcModel, eocDto, monitorData);
            return executionClient.callExecution(param, true);
        }
    }

    private void initLocale() {
        String locale = (String) DWServiceContext.getContext().getRequestHeader().get(FieldConstant.LOCALE);
        if (StringUtil.isBlank(locale)) {
            locale = iamClient.getDefaultLocale();
            DWServiceContext.getContext().getRequestHeader().put(FieldConstant.LOCALE, locale);
        }
    }

    @Override
    public ResultDto executeDeliver(JSONObject recordJsonObject) {
        JSONObject after = ObjectUtils.isEmpty(recordJsonObject.getJSONObject(FieldConstant.DATA_AFTER)) ? recordJsonObject.getJSONObject(FieldConstant.DATA_BEFORE) : recordJsonObject.getJSONObject(FieldConstant.DATA_AFTER);
        String tenantId = after.getString(FieldConstant.TENANT_ID);
        String tenantSid = after.getString(FieldConstant.TENANT_SID);
        if (StringUtils.isEmpty(tenantId) && StringUtils.isEmpty(tenantSid)) {
            LOGGER.error("接收CDC的转发消息中没有tenantId或者tenantSid，该变化的数据无法处理");
        } else {
            if (StringUtils.isEmpty(tenantId)) {
                LOGGER.info("接收CDC的转发消息中有tenantSid:{}", tenantSid);
                String redisKey = MonitorHelper.buildCdcTsid(tenantSid);
                if (redisService.hasKey(redisKey)) {
                    tenantId = redisService.get(redisKey);
                } else {
                    // 从iam获取租户ID
                    JSONObject tenantJsonObject = iamClient.getTenantId(tenantSid);
                    if (Objects.isNull(tenantJsonObject) || StringUtils.isEmpty(tenantJsonObject.getString(FieldConstant.TENANTID))) {
                        LOGGER.error("根据tenantSid从IAM获取不到租户信息，tenantSid={}", tenantSid);
                        return ResultHelper.generateSuccessResult("");
                    }
                    tenantId = tenantJsonObject.getString(FieldConstant.TENANTID);
                    redisService.set(redisKey, tenantId, FieldConstant.CDCTSID_EXPIRE);
                }

            } else {
                LOGGER.info("接收CDC的转发消息中有tenantId:{}", tenantId);
            }

            try {
                contextService.constructContext(tenantId);
                routerClient.deliver(JSON.toJSONString(recordJsonObject), tenantId);
            } catch (Throwable e) {
                LOGGER.error("处理消息构建上下文失败，tenantId={}，异常:[{}]", recordJsonObject.getString(FieldConstant.TENANTID), e);
                return ResultHelper.generateFailResult("执行路由分发失败");
            }
        }

        return ResultHelper.generateSuccessResult("");
    }
}
