package com.digiwin.athena.cdme.service.facade.ops.impl;

import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.enums.ErrorCodeEnum;
import com.digiwin.athena.cdme.core.exception.BusinessException;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.core.util.StringUtil;
import com.digiwin.athena.cdme.pojo.dto.EocDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.service.client.IScwokerClient;
import com.digiwin.athena.cdme.service.client.IThemeMapClient;
import com.digiwin.athena.cdme.service.client.response.ActionMetaDataRes;
import com.digiwin.athena.cdme.service.facade.ops.IMonitorValidationFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description: 检查服务
 * @author: liunansheng
 * @date: 2021/10/22 15:39
 */
@Service("cdmeMonitorValidationFacadeService")
public class MonitorValidationFacadeService implements IMonitorValidationFacadeService {
    @Autowired
    private IThemeMapClient iThemeMapClient;

    @Autowired
    private IScwokerClient iScwokerClient;

    @Override
    public boolean existActiveProject(String actionId, String tenantId, EocDto eocDto) {
        /** step1 参数校验 */
        ResultDto validResult = validParam(actionId, tenantId);
        if (MonitorHelper.isResultFail(validResult)) {
            throw new BusinessException(ErrorCodeEnum.PARAM_EMPTY_ERR);
        }
        /** step2 查询action元数据*/
        ActionMetaDataRes actionMetaDataRes = iThemeMapClient.getActionMetaData(actionId);
        /** 不是服务编排类型，则不检查，直接返回不存在*/
        if (!FieldValConstant.ACTION_TYPE_SCWORKER.equals(actionMetaDataRes.getType())) {
            return false;
        }
        /** step3 查询是否有进行中项目*/
        return iScwokerClient.existActiveProject(actionMetaDataRes.getServiceComposerId(), tenantId, eocDto);
    }

    private ResultDto validParam(String actionId, String tenantId) {
        if (StringUtil.isBlank(actionId)) {
            return ResultHelper.generateFailResult("actionId不可为空");
        }
        if (StringUtil.isBlank(tenantId)) {
            return ResultHelper.generateFailResult("tenantId不可为空");
        }
        return ResultHelper.generateSuccessResult(null);
    }
}
