package com.digiwin.athena.cdme.service.facade.rulesync.impl;

import com.digiwin.athena.cdme.constant.FieldValConstant;
import com.digiwin.athena.cdme.core.enums.ResultEnum;
import com.digiwin.athena.cdme.core.util.MonitorHelper;
import com.digiwin.athena.cdme.core.util.ResultHelper;
import com.digiwin.athena.cdme.pojo.dto.MonitorCdcRuleDto;
import com.digiwin.athena.cdme.pojo.dto.ResultDto;
import com.digiwin.athena.cdme.pojo.dto.SyncRuleParamDto;
import com.digiwin.athena.cdme.service.client.IScheduleClient;
import com.digiwin.athena.cdme.service.facade.ops.IRuleTriggerOperatorFacadeService;
import com.digiwin.athena.cdme.service.facade.rulesync.ISyncFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @description: 停用侦测规则
 * 2023 S12 设置为过时，后期会删掉该接口
 * 2024 S6 MQTT侦测需要使用此能力
 * @author: dongwh
 * @date: 2021/10/20 14:27
 */
@Deprecated
@Service(FieldValConstant.MONITOR_RULE_DISABLED)
public class DisableService implements ISyncFacadeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisableService.class);

    private final IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService;

    public DisableService(IRuleTriggerOperatorFacadeService ruleTriggerOperatorFacadeService, IScheduleClient scheduleClient) {
        this.ruleTriggerOperatorFacadeService = ruleTriggerOperatorFacadeService;
    }

    @Override
    public ResultDto syncMonitorRuleHandler(SyncRuleParamDto ruleDto) {
        LOGGER.info("停用CDC侦测规则入参:{}", ruleDto);
        MonitorCdcRuleDto monitorRuleDto = ruleTriggerOperatorFacadeService.queryCdcRuleDetailByRuleId(ruleDto.getRuleId(), ruleDto.getTenantId(), ruleDto.getEocMap());
        ResultDto validResult = validRuleExists(monitorRuleDto);
        if (MonitorHelper.isResultFail(validResult)) {
            return validResult;
        }
        monitorRuleDto.getRuleModel().setValid(FieldValConstant.RULE_DISABLE);
        ruleTriggerOperatorFacadeService.modifyCdcRule(monitorRuleDto);
        LOGGER.info("停用CDC侦测规则成功");
        return ResultHelper.generateResult(true, ResultEnum.RULE_SCHEDULE_SUCCESS.getMessage());
    }
}
